/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.util;

import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BOverride is the argument used on the writable point override actions.
 *
 * @author    Brian Frank
 * @creation  21 Jun 04
 * @version   $Revision: 4$ $Date: 7/27/10 12:19:15 PM EDT$
 * @since     Baja 1.0
 */
public class BOverride
  extends BStruct
{
/*-
  class BOverride
  {
    properties
    {
      duration: BRelTime
        -- Duration of time for the override or 0 for no expiration.
        default {[ BRelTime.make(0) ]}
        
      maxOverrideDuration: BRelTime
        -- Max override duration. Please note, this is a FW only 
        -- Property and replaces the previous maxOverrideDuration field
        flags{ hidden, transient }
        default{[ BRelTime.DEFAULT ]}
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.util.BOverride(807179693)1.0$ @*/
/* Generated Tue Jul 27 17:05:43 BST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "duration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>duration</code> property.
   * Duration of time for the override or 0 for no expiration.
   * @see javax.baja.control.util.BOverride#getDuration
   * @see javax.baja.control.util.BOverride#setDuration
   */
  public static final Property duration = newProperty(0, BRelTime.make(0),null);
  
  /**
   * Get the <code>duration</code> property.
   * @see javax.baja.control.util.BOverride#duration
   */
  public BRelTime getDuration() { return (BRelTime)get(duration); }
  
  /**
   * Set the <code>duration</code> property.
   * @see javax.baja.control.util.BOverride#duration
   */
  public void setDuration(BRelTime v) { set(duration,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxOverrideDuration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxOverrideDuration</code> property.
   * Max override duration. Please note, this is a FW only
   * Property and replaces the previous maxOverrideDuration
   * field
   * @see javax.baja.control.util.BOverride#getMaxOverrideDuration
   * @see javax.baja.control.util.BOverride#setMaxOverrideDuration
   */
  public static final Property maxOverrideDuration = newProperty(Flags.HIDDEN|Flags.TRANSIENT, BRelTime.DEFAULT,null);
  
  /**
   * Get the <code>maxOverrideDuration</code> property.
   * @see javax.baja.control.util.BOverride#maxOverrideDuration
   */
  public BRelTime getMaxOverrideDuration() { return (BRelTime)get(maxOverrideDuration); }
  
  /**
   * Set the <code>maxOverrideDuration</code> property.
   * @see javax.baja.control.util.BOverride#maxOverrideDuration
   */
  public void setMaxOverrideDuration(BRelTime v) { set(maxOverrideDuration,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOverride.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  public String toString(Context cx)
  {            
    // get value (or null if no associated value)
    BValue val = get("value");
    String valStr = null;
    if (val != null)
      valStr = val.toString(cx);
    
    // get duration string
    BRelTime dur = getDuration();      
    String durStr;                 
    if (dur.getMillis() == 0)
      durStr = "permanent";
    else
      durStr = dur.toString(cx);
    
    if (valStr == null)
      return durStr;  
    else
      return valStr + " : " + durStr;
  }         
  
  String valueToString(Context cx)
  {      
    return null;
  } 
}
