/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.util;

import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BNumericOverride is the override argument for NumericWritable.
 *
 * @author    Brian Frank
 * @creation  21 Jun 04
 * @version   $Revision: 1$ $Date: 6/22/04 8:35:23 AM EDT$
 * @since     Baja 1.0
 */
public class BNumericOverride
  extends BOverride
{

  /*-

  class BNumericOverride
  {
    properties
    {
      value: double
        -- Value of the override.
        default {[ 0 ]}
    }

  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.util.BNumericOverride(2090428800)1.0$ @*/
/* Generated Mon Jun 21 17:36:23 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * Value of the override.
   * @see javax.baja.control.util.BNumericOverride#getValue
   * @see javax.baja.control.util.BNumericOverride#setValue
   */
  public static final Property value = newProperty(0, 0,null);
  
  /**
   * Get the <code>value</code> property.
   * @see javax.baja.control.util.BNumericOverride#value
   */
  public double getValue() { return getDouble(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see javax.baja.control.util.BNumericOverride#value
   */
  public void setValue(double v) { setDouble(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericOverride.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BNumericOverride(BRelTime duration, double value)
  {                                          
    setDuration(duration);
    setValue(value);
  }

  public BNumericOverride(double value)
  {                                   
    setValue(value);
  }

  public BNumericOverride()
  {
  }

}
