/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.util;

import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BEnumOverride is the override argument for EnumWritable.
 *
 * @author    Brian Frank
 * @creation  21 Jun 04
 * @version   $Revision: 1$ $Date: 6/22/04 8:35:23 AM EDT$
 * @since     Baja 1.0
 */
public class BEnumOverride
  extends BOverride
{

  /*-

  class BEnumOverride
  {
    properties
    {
      value: BDynamicEnum
        -- Value of the override.
        default {[ BDynamicEnum.DEFAULT ]}
    }

  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.util.BEnumOverride(4075291319)1.0$ @*/
/* Generated Mon Jun 21 20:27:07 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * Value of the override.
   * @see javax.baja.control.util.BEnumOverride#getValue
   * @see javax.baja.control.util.BEnumOverride#setValue
   */
  public static final Property value = newProperty(0, BDynamicEnum.DEFAULT,null);
  
  /**
   * Get the <code>value</code> property.
   * @see javax.baja.control.util.BEnumOverride#value
   */
  public BDynamicEnum getValue() { return (BDynamicEnum)get(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see javax.baja.control.util.BEnumOverride#value
   */
  public void setValue(BDynamicEnum v) { set(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumOverride.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BEnumOverride(BRelTime duration, BDynamicEnum value)
  {                                          
    setDuration(duration);
    setValue(value);
  }

  public BEnumOverride(BDynamicEnum value)
  {                                   
    setValue(value);
  }

  public BEnumOverride()
  {
  }

}
