/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.ext;

import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BNullProxyExt is the default implement BAbstractProxyExt
 * used to indicate that a point is not a proxy.
 *
 * @author    Brian Frank
 * @creation  1 May 02
 * @version   $Revision: 7$ $Date: 3/28/05 11:40:33 AM EST$
 * @since     Baja 1.0
 */
public final class BNullProxyExt
  extends BAbstractProxyExt
{

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNullProxyExt.class);
  
  public boolean isNull() { return true; }
  
  public String toString(Context cx) { return "null"; }
  
}

