/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.ext;

import javax.baja.control.BDiscretePoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.enums.BCountTransition;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BDiscreteTotalizerExt is a standard point extension useful
 * for accumulating run time and change of state counts
 * on binary or enum values.
 *
 * @author    Dan Giorgis
 * @creation   1 Nov 00
 * @version   $Revision: 36$ $Date: 7/8/09 3:16:32 PM EDT$
 * @since     Baja 1.0
 */

//  FIXX - elapsed active time should track status input (feedback value)
//  not present value - how to implement in R3?


public class BDiscreteTotalizerExt
  extends BPointExtension
{ 

  /*-
  
  class BDiscreteTotalizerExt
  {
    properties
    {
      changeOfStateCountTransition :  BCountTransition
        default {[ BCountTransition.both ]}
      
      propagateFlags: BStatus
      -- defines which input status flags will be propagated from
      -- input to output.
        default{[ BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED ) ]}
      invalidValueFlags: BStatus
      -- defines which input status flags will denote invalid input 
      -- values that should not be included in the total
        default{[ BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED) ]}
      
      changeOfStateTime: BAbsTime
        -- Shows a date/timestamp for the last change of state. 
        flags { readonly }
        default {[ BAbsTime.make() ]}
      changeOfStateCount: int
        -- Shows the total number of changes of state that have occurred 
        -- since the last reset of change of state count.
        flags { readonly }
        default {[ 0 ]}
      timeOfStateCountReset: BAbsTime
        -- Shows a date/timestamp for when the change of state count was last cleared. 
        flags { readonly }
        default {[ BAbsTime.make() ]}
      elapsedActiveTime: BRelTime
        -- Shows the accumulated runtime (elapsed active time).
        flags { readonly }
        default {[ BRelTime.DEFAULT ]}
      elapsedActiveTimeNumeric: BStatusNumeric
        -- Shows the accumulated runtime as a numeric.
        flags { readonly }
        default {[ new BStatusNumeric() ]}
      timeOfActiveTimeReset: BAbsTime
        -- Shows a date/timestamp for when the accumulated runtime (elapsed active time) was last cleared. 
        flags { readonly }
        default {[ BAbsTime.make() ]}
       eaTimeUpdateInterval : BRelTime
        -- Shows the minimum update time for Elapsed Active Time and Elapsed Active Time Numeric properties.
        flags { summary }
        default {[ BRelTime.makeSeconds(10) ]}
    }

    actions
    {
      timerExpired()         
        -- timerExpired  
        flags { hidden }
      resetChangeOfStateCount()
        -- This sets the changeOfStateCount property value to zero (0), clearing any change of state count. 
        flags { confirmRequired }
      resetElapsedActiveTime()
        -- This sets the elapsedActiveTime property value to zero, clearing any accumulated runtime. 
        flags { confirmRequired }
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.ext.BDiscreteTotalizerExt(2261797193)1.0$ @*/
/* Generated Fri Mar 21 10:21:48 EDT 2014 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "changeOfStateCountTransition"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>changeOfStateCountTransition</code> property.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getChangeOfStateCountTransition
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setChangeOfStateCountTransition
   */
  public static final Property changeOfStateCountTransition = newProperty(0, BCountTransition.both,null);
  
  /**
   * Get the <code>changeOfStateCountTransition</code> property.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#changeOfStateCountTransition
   */
  public BCountTransition getChangeOfStateCountTransition() { return (BCountTransition)get(changeOfStateCountTransition); }
  
  /**
   * Set the <code>changeOfStateCountTransition</code> property.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#changeOfStateCountTransition
   */
  public void setChangeOfStateCountTransition(BCountTransition v) { set(changeOfStateCountTransition,v,null); }

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getPropagateFlags
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED ),null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Property "invalidValueFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>invalidValueFlags</code> property.
   * defines which input status flags will denote invalid
   * input values that should not be included in the total
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getInvalidValueFlags
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setInvalidValueFlags
   */
  public static final Property invalidValueFlags = newProperty(0, BStatus.make(BStatus.FAULT | BStatus.DOWN | BStatus.DISABLED),null);
  
  /**
   * Get the <code>invalidValueFlags</code> property.
   * defines which input status flags will denote invalid
   * input values that should not be included in the total
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#invalidValueFlags
   */
  public BStatus getInvalidValueFlags() { return (BStatus)get(invalidValueFlags); }
  
  /**
   * Set the <code>invalidValueFlags</code> property.
   * defines which input status flags will denote invalid
   * input values that should not be included in the total
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#invalidValueFlags
   */
  public void setInvalidValueFlags(BStatus v) { set(invalidValueFlags,v,null); }

////////////////////////////////////////////////////////////////
// Property "changeOfStateTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>changeOfStateTime</code> property.
   * Shows a date/timestamp for the last change of state.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getChangeOfStateTime
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setChangeOfStateTime
   */
  public static final Property changeOfStateTime = newProperty(Flags.READONLY, BAbsTime.make(),null);
  
  /**
   * Get the <code>changeOfStateTime</code> property.
   * Shows a date/timestamp for the last change of state.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#changeOfStateTime
   */
  public BAbsTime getChangeOfStateTime() { return (BAbsTime)get(changeOfStateTime); }
  
  /**
   * Set the <code>changeOfStateTime</code> property.
   * Shows a date/timestamp for the last change of state.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#changeOfStateTime
   */
  public void setChangeOfStateTime(BAbsTime v) { set(changeOfStateTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "changeOfStateCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>changeOfStateCount</code> property.
   * Shows the total number of changes of state that have
   * occurred since the last reset of change of state count.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getChangeOfStateCount
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setChangeOfStateCount
   */
  public static final Property changeOfStateCount = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>changeOfStateCount</code> property.
   * Shows the total number of changes of state that have
   * occurred since the last reset of change of state count.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#changeOfStateCount
   */
  public int getChangeOfStateCount() { return getInt(changeOfStateCount); }
  
  /**
   * Set the <code>changeOfStateCount</code> property.
   * Shows the total number of changes of state that have
   * occurred since the last reset of change of state count.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#changeOfStateCount
   */
  public void setChangeOfStateCount(int v) { setInt(changeOfStateCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "timeOfStateCountReset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timeOfStateCountReset</code> property.
   * Shows a date/timestamp for when the change of state
   * count was last cleared.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getTimeOfStateCountReset
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setTimeOfStateCountReset
   */
  public static final Property timeOfStateCountReset = newProperty(Flags.READONLY, BAbsTime.make(),null);
  
  /**
   * Get the <code>timeOfStateCountReset</code> property.
   * Shows a date/timestamp for when the change of state
   * count was last cleared.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#timeOfStateCountReset
   */
  public BAbsTime getTimeOfStateCountReset() { return (BAbsTime)get(timeOfStateCountReset); }
  
  /**
   * Set the <code>timeOfStateCountReset</code> property.
   * Shows a date/timestamp for when the change of state
   * count was last cleared.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#timeOfStateCountReset
   */
  public void setTimeOfStateCountReset(BAbsTime v) { set(timeOfStateCountReset,v,null); }

////////////////////////////////////////////////////////////////
// Property "elapsedActiveTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>elapsedActiveTime</code> property.
   * Shows the accumulated runtime (elapsed active time).
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getElapsedActiveTime
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setElapsedActiveTime
   */
  public static final Property elapsedActiveTime = newProperty(Flags.READONLY, BRelTime.DEFAULT,null);
  
  /**
   * Get the <code>elapsedActiveTime</code> property.
   * Shows the accumulated runtime (elapsed active time).
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#elapsedActiveTime
   */
  public BRelTime getElapsedActiveTime() { return (BRelTime)get(elapsedActiveTime); }
  
  /**
   * Set the <code>elapsedActiveTime</code> property.
   * Shows the accumulated runtime (elapsed active time).
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#elapsedActiveTime
   */
  public void setElapsedActiveTime(BRelTime v) { set(elapsedActiveTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "elapsedActiveTimeNumeric"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>elapsedActiveTimeNumeric</code> property.
   * Shows the accumulated runtime as a numeric.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getElapsedActiveTimeNumeric
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setElapsedActiveTimeNumeric
   */
  public static final Property elapsedActiveTimeNumeric = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>elapsedActiveTimeNumeric</code> property.
   * Shows the accumulated runtime as a numeric.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#elapsedActiveTimeNumeric
   */
  public BStatusNumeric getElapsedActiveTimeNumeric() { return (BStatusNumeric)get(elapsedActiveTimeNumeric); }
  
  /**
   * Set the <code>elapsedActiveTimeNumeric</code> property.
   * Shows the accumulated runtime as a numeric.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#elapsedActiveTimeNumeric
   */
  public void setElapsedActiveTimeNumeric(BStatusNumeric v) { set(elapsedActiveTimeNumeric,v,null); }

////////////////////////////////////////////////////////////////
// Property "timeOfActiveTimeReset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timeOfActiveTimeReset</code> property.
   * Shows a date/timestamp for when the accumulated runtime
   * (elapsed active time) was last cleared.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getTimeOfActiveTimeReset
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setTimeOfActiveTimeReset
   */
  public static final Property timeOfActiveTimeReset = newProperty(Flags.READONLY, BAbsTime.make(),null);
  
  /**
   * Get the <code>timeOfActiveTimeReset</code> property.
   * Shows a date/timestamp for when the accumulated runtime
   * (elapsed active time) was last cleared.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#timeOfActiveTimeReset
   */
  public BAbsTime getTimeOfActiveTimeReset() { return (BAbsTime)get(timeOfActiveTimeReset); }
  
  /**
   * Set the <code>timeOfActiveTimeReset</code> property.
   * Shows a date/timestamp for when the accumulated runtime
   * (elapsed active time) was last cleared.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#timeOfActiveTimeReset
   */
  public void setTimeOfActiveTimeReset(BAbsTime v) { set(timeOfActiveTimeReset,v,null); }

////////////////////////////////////////////////////////////////
// Property "eaTimeUpdateInterval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>eaTimeUpdateInterval</code> property.
   * Shows the minimum update time for Elapsed Active Time
   * and Elapsed Active Time Numeric properties.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#getEaTimeUpdateInterval
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#setEaTimeUpdateInterval
   */
  public static final Property eaTimeUpdateInterval = newProperty(Flags.SUMMARY, BRelTime.makeSeconds(10),null);
  
  /**
   * Get the <code>eaTimeUpdateInterval</code> property.
   * Shows the minimum update time for Elapsed Active Time
   * and Elapsed Active Time Numeric properties.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#eaTimeUpdateInterval
   */
  public BRelTime getEaTimeUpdateInterval() { return (BRelTime)get(eaTimeUpdateInterval); }
  
  /**
   * Set the <code>eaTimeUpdateInterval</code> property.
   * Shows the minimum update time for Elapsed Active Time
   * and Elapsed Active Time Numeric properties.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#eaTimeUpdateInterval
   */
  public void setEaTimeUpdateInterval(BRelTime v) { set(eaTimeUpdateInterval,v,null); }

////////////////////////////////////////////////////////////////
// Action "timerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timerExpired</code> action.
   * timerExpired
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#timerExpired()
   */
  public static final Action timerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>timerExpired</code> action.
   * timerExpired
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#timerExpired
   */
  public void timerExpired() { invoke(timerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Action "resetChangeOfStateCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetChangeOfStateCount</code> action.
   * This sets the changeOfStateCount property value to
   * zero (0), clearing any change of state count.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#resetChangeOfStateCount()
   */
  public static final Action resetChangeOfStateCount = newAction(Flags.CONFIRM_REQUIRED,null);
  
  /**
   * Invoke the <code>resetChangeOfStateCount</code> action.
   * This sets the changeOfStateCount property value to
   * zero (0), clearing any change of state count.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#resetChangeOfStateCount
   */
  public void resetChangeOfStateCount() { invoke(resetChangeOfStateCount,null,null); }

////////////////////////////////////////////////////////////////
// Action "resetElapsedActiveTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetElapsedActiveTime</code> action.
   * This sets the elapsedActiveTime property value to zero, clearing any accumulated runtime.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#resetElapsedActiveTime()
   */
  public static final Action resetElapsedActiveTime = newAction(Flags.CONFIRM_REQUIRED,null);
  
  /**
   * Invoke the <code>resetElapsedActiveTime</code> action.
   * This sets the elapsedActiveTime property value to zero, clearing any accumulated runtime.
   * @see javax.baja.control.ext.BDiscreteTotalizerExt#resetElapsedActiveTime
   */
  public void resetElapsedActiveTime() { invoke(resetElapsedActiveTime,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDiscreteTotalizerExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void started()
  {
    elapsedTimeMillis = getElapsedActiveTime().getMillis();
    update(getParentPoint().getOutStatusValue());
  }

  public void stopped()
  {
    if (ticket != null) ticket.cancel();
  }

////////////////////////////////////////////////////////////////
//PointExtension
////////////////////////////////////////////////////////////////
  
  public boolean requiresPointSubscription()
  {
    return true;
  }

////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////  

  /**
   * Parent must be a DiscretePoint. 
   */
  public boolean isParentLegal(BComponent parent)
  {                
    if (!super.isParentLegal(parent)) return false;
    return parent instanceof BDiscretePoint;
  }

  /**
   * Any sibling is legal for an alarm extension.
   */
  protected boolean isSiblingLegal(BComponent sibling)
  {
    return true;
  }

////////////////////////////////////////////////////////////////
// Update Methods
////////////////////////////////////////////////////////////////

  /**
   * Callback for timer expired.
   */
  public void doTimerExpired()
  {
     update(getParentPoint().getOutStatusValue());
  }

  /** 
   * Called when either me or my parent control 
   * point is updated.
   */ 
  public void onExecute(BStatusValue out, Context cx)
  {
    update(out);
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////
  
  public void doResetChangeOfStateCount()
  {                  
    setChangeOfStateCount(0);
    setTimeOfStateCountReset(Clock.time());   
  }

  public void doResetElapsedActiveTime()
  {               
    setElapsedActiveTime(BRelTime.DEFAULT);      
    getElapsedActiveTimeNumeric().setValue(0.0);      
    setTimeOfActiveTimeReset(Clock.time());
    
    lastActiveTime = 0;     
    elapsedTimeMillis = 0;
    
    BDiscretePoint point = (BDiscretePoint)getParentPoint();
    if (point != null)
      update(point.getOutStatusValue());
  
    forceUpdate = true;    
  }

////////////////////////////////////////////////////////////////
//  Internal Utility Methods
////////////////////////////////////////////////////////////////  

  /**
   * Sets changeOfStateCount, changeOfStateTime, elapsedActiveTime, and elapsedActiveTimeNumeric.
   * A lock is required on this method to prevent another call to it from using a previous value of
   * changeOfStateCount (there may be other side-effects of concurrent processing as well).
   * Previously, a lock other than "this" was used but that would cause a deadlock when trying to
   * set property values if the component was already locked, such as when it was being added to a
   * point.
   *
   * There was also an issue where onExecute would run before started was called and that
   * would reset a persisted elapsedActiveTime value. The started issue could be solved with an
   * AtomicBoolean tracking whether started has completed but this did not prevent deadlocks. By
   * locking on "this", onExecute will not be able to call update until started is finished and its
   * lock on "this" is released.
   */
  private synchronized void update(BStatusValue out)
  {
    // Short-circuits if called from onExecute after the component has been stopped. This should
    // occur inside of a lock on "this" so the isRunning check does not occur before stop has set
    // it.
    if (!isRunning())
    {
      return;
    }

     // these are properties we might want to set    
    BAbsTime cosTime = null;
    int cosCount = -1;
    
    BRelTime elapsedTime = null;    
    
    BStatus status = out.getStatus();

    // are we currently active?
    boolean isActive = ((BIEnum)out).getEnum().isActive();

    // check for change of state
    boolean countIt = false;
    if((status.getBits() & getInvalidValueFlags().getBits())==0)
    {
      switch(getChangeOfStateCountTransition().getOrdinal())
      {
        case BCountTransition.TO_ACTIVE:
          countIt = !lastActive && isActive;
          break;
        case BCountTransition.TO_INACTIVE:
          countIt = lastActive && !isActive;
          break;
        default:
          countIt = lastActive != isActive;
      }
      lastActive = isActive;
    }
    if (countIt)
    {
      cosCount = getChangeOfStateCount() + 1;
      cosTime =  Clock.time();
    }

    // update elapsed active time
    long now = Clock.ticks();


    //  Add to the accumulated active time calculation
    if (lastActiveTime != 0)
    {
      elapsedTimeMillis += (now - lastActiveTime);
      elapsedTime = BRelTime.make(elapsedTimeMillis);
    }

    if (isActive && (status.getBits() & getInvalidValueFlags().getBits())==0)
    {
      lastActiveTime = now;
      if(ticket==null || ticket.isExpired())
      {
         ticket = Clock.schedulePeriodically(this, BRelTime.make(1000), timerExpired, null);
      }
    }
    else
    {
      if(ticket!=null && !ticket.isExpired())
        ticket.cancel();
      lastActiveTime = 0;
    }

    if (cosTime != null )
    {
      setChangeOfStateCount(cosCount);
      setChangeOfStateTime(cosTime);
    }

    // Wait for minimum update time and ignore this only when reset happens
    if (elapsedTime != null && (((now - lastEATUpdateTime ) > getEaTimeUpdateInterval().getMillis()) || forceUpdate))
    {
      setElapsedActiveTime(elapsedTime);
      getElapsedActiveTimeNumeric().setValue(elapsedTime.getMillis());
      lastEATUpdateTime = now;
      forceUpdate = false;
      getParentPoint().execute();
    }
    getElapsedActiveTimeNumeric().setStatus(BStatus.make(status.getBits() & getPropagateFlags().getBits()));
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
   
  private Clock.Ticket ticket;
  private boolean lastActive;
  
  private boolean forceUpdate;

  private long lastEATUpdateTime = 0; // Last Elapsed Active Time update Time
  
  private long lastActiveTime = 0;
  private long elapsedTimeMillis = 0;
}
