/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BTotalizationInterval is a BEnum specifying totalization
 * intervals.
 *
 * @author    Dan Giorgis
 * @creation  9 Nov 00
 * @version   $Revision: 11$ $Date: 3/23/05 11:37:10 AM EST$
 * @since     Baja 1.0
 */
public final class BTotalizationInterval
  extends BFrozenEnum
{

  /*-
  
  enum BTotalizationInterval
  {
    range
    {
      minutely,
      hourly
    }
  }
  
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.enums.BTotalizationInterval(1693513128)1.0$ @*/
/* Generated Fri Feb 17 09:54:14 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for minutely. */
  public static final int MINUTELY = 0;
  /** Ordinal value for hourly. */
  public static final int HOURLY = 1;
  
  /** BTotalizationInterval constant for minutely. */
  public static final BTotalizationInterval minutely = new BTotalizationInterval(MINUTELY);
  /** BTotalizationInterval constant for hourly. */
  public static final BTotalizationInterval hourly = new BTotalizationInterval(HOURLY);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTotalizationInterval.class);
  
  /** Factory method with ordinal. */
  public static BTotalizationInterval make(int ordinal)
  {
    return (BTotalizationInterval)minutely.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BTotalizationInterval make(String tag)
  {
    return (BTotalizationInterval)minutely.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BTotalizationInterval(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BTotalizationInterval DEFAULT = BTotalizationInterval.minutely;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

      
}

