/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BCountTransition is a BEnum specifying changeOfState edge to count.
 *
 * @author    Andy Saunders
 * @creation  22 Nov 2004
 * @version   $Revision: 2$ $Date: 3/23/05 11:37:10 AM EST$
 * @since     Baja 1.0
 */
public final class BCountTransition
  extends BFrozenEnum
{

  /*-
  
  enum BCountTransition
  {
    range
    {
      toActive,
      toInactive,
      both
    }
  }
  
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.enums.BCountTransition(267256184)1.0$ @*/
/* Generated Fri Feb 17 09:54:14 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for toActive. */
  public static final int TO_ACTIVE = 0;
  /** Ordinal value for toInactive. */
  public static final int TO_INACTIVE = 1;
  /** Ordinal value for both. */
  public static final int BOTH = 2;
  
  /** BCountTransition constant for toActive. */
  public static final BCountTransition toActive = new BCountTransition(TO_ACTIVE);
  /** BCountTransition constant for toInactive. */
  public static final BCountTransition toInactive = new BCountTransition(TO_INACTIVE);
  /** BCountTransition constant for both. */
  public static final BCountTransition both = new BCountTransition(BOTH);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCountTransition.class);
  
  /** Factory method with ordinal. */
  public static BCountTransition make(int ordinal)
  {
    return (BCountTransition)toActive.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BCountTransition make(String tag)
  {
    return (BCountTransition)toActive.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BCountTransition(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BCountTransition DEFAULT = BCountTransition.toActive;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

      
}

