/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BStringOverride;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.util.ObjectUtil;

/**
 * BStringWritable defines a writable control point with 16 input levels.
 *
 * @author    Craig Gemmill
 * @creation  11 Feb 02
 * @version   $Revision: 28$ $Date: 7/27/10 12:19:15 PM EDT$
 * @since     Baja 1.0
 */
public class BStringWritable
  extends BStringPoint
  implements BIWritablePoint
{

  /*-

  class BStringWritable
  {
    properties
    {
      in1: BStatusString
        -- The last command at this priority level.
        -- Commands at emergency level 1 are persisted.
        flags { readonly }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in2: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in3: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in4: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in5: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in6: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in7: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in8: BStatusString
        -- The last command at this priority level.
        -- Commands at manual level 8 are persisted.
        flags { readonly }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in9: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in10: BStatusString
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in11: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in12: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in13: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in14: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in15: BStatusString
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}
      in16: BStatusString
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusString("", BStatus.nullStatus) ]}

      fallback: BStatusString
        -- This is the value to use if none of the levels are valid.
        default {[ new BStatusString("", BStatus.nullStatus) ]}

      overrideExpiration: BAbsTime
        -- Time which override will expire
        flags { operator, readonly }
        default {[ BAbsTime.NULL ]}
    }

    actions
    {
      emergencyOverride(arg: BString)
        -- To set an output value at the Emergency level (1).
        default {[ BString.make("") ]}
      emergencyAuto()
        -- To clear an output value set at the Emergency level (1).

      override(arg: BStringOverride)
        -- To set an output value at the Manual level (8).
        flags { operator }
        default {[ new BStringOverride() ]}
      auto()
        -- To clear an output value set at the Manual level (8).
        flags { operator }

      set(arg: BString)
        -- Set the fallback property value.
        flags { operator }
        default {[ BString.DEFAULT ]}
    }

  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BStringWritable(2062971973)1.0$ @*/
/* Generated Tue Jun 22 13:23:20 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "in1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in1</code> property.
   * The last command at this priority level. Commands at emergency level 1 are persisted.
   * @see javax.baja.control.BStringWritable#getIn1
   * @see javax.baja.control.BStringWritable#setIn1
   */
  public static final Property in1 = newProperty(Flags.READONLY, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in1</code> property.
   * @see javax.baja.control.BStringWritable#in1
   */
  public BStatusString getIn1() { return (BStatusString)get(in1); }
  
  /**
   * Set the <code>in1</code> property.
   * @see javax.baja.control.BStringWritable#in1
   */
  public void setIn1(BStatusString v) { set(in1,v,null); }

////////////////////////////////////////////////////////////////
// Property "in2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in2</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn2
   * @see javax.baja.control.BStringWritable#setIn2
   */
  public static final Property in2 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in2</code> property.
   * @see javax.baja.control.BStringWritable#in2
   */
  public BStatusString getIn2() { return (BStatusString)get(in2); }
  
  /**
   * Set the <code>in2</code> property.
   * @see javax.baja.control.BStringWritable#in2
   */
  public void setIn2(BStatusString v) { set(in2,v,null); }

////////////////////////////////////////////////////////////////
// Property "in3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in3</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn3
   * @see javax.baja.control.BStringWritable#setIn3
   */
  public static final Property in3 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in3</code> property.
   * @see javax.baja.control.BStringWritable#in3
   */
  public BStatusString getIn3() { return (BStatusString)get(in3); }
  
  /**
   * Set the <code>in3</code> property.
   * @see javax.baja.control.BStringWritable#in3
   */
  public void setIn3(BStatusString v) { set(in3,v,null); }

////////////////////////////////////////////////////////////////
// Property "in4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in4</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn4
   * @see javax.baja.control.BStringWritable#setIn4
   */
  public static final Property in4 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in4</code> property.
   * @see javax.baja.control.BStringWritable#in4
   */
  public BStatusString getIn4() { return (BStatusString)get(in4); }
  
  /**
   * Set the <code>in4</code> property.
   * @see javax.baja.control.BStringWritable#in4
   */
  public void setIn4(BStatusString v) { set(in4,v,null); }

////////////////////////////////////////////////////////////////
// Property "in5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in5</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn5
   * @see javax.baja.control.BStringWritable#setIn5
   */
  public static final Property in5 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in5</code> property.
   * @see javax.baja.control.BStringWritable#in5
   */
  public BStatusString getIn5() { return (BStatusString)get(in5); }
  
  /**
   * Set the <code>in5</code> property.
   * @see javax.baja.control.BStringWritable#in5
   */
  public void setIn5(BStatusString v) { set(in5,v,null); }

////////////////////////////////////////////////////////////////
// Property "in6"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in6</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn6
   * @see javax.baja.control.BStringWritable#setIn6
   */
  public static final Property in6 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in6</code> property.
   * @see javax.baja.control.BStringWritable#in6
   */
  public BStatusString getIn6() { return (BStatusString)get(in6); }
  
  /**
   * Set the <code>in6</code> property.
   * @see javax.baja.control.BStringWritable#in6
   */
  public void setIn6(BStatusString v) { set(in6,v,null); }

////////////////////////////////////////////////////////////////
// Property "in7"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in7</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn7
   * @see javax.baja.control.BStringWritable#setIn7
   */
  public static final Property in7 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in7</code> property.
   * @see javax.baja.control.BStringWritable#in7
   */
  public BStatusString getIn7() { return (BStatusString)get(in7); }
  
  /**
   * Set the <code>in7</code> property.
   * @see javax.baja.control.BStringWritable#in7
   */
  public void setIn7(BStatusString v) { set(in7,v,null); }

////////////////////////////////////////////////////////////////
// Property "in8"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in8</code> property.
   * The last command at this priority level. Commands at manual level 8 are persisted.
   * @see javax.baja.control.BStringWritable#getIn8
   * @see javax.baja.control.BStringWritable#setIn8
   */
  public static final Property in8 = newProperty(Flags.READONLY, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in8</code> property.
   * @see javax.baja.control.BStringWritable#in8
   */
  public BStatusString getIn8() { return (BStatusString)get(in8); }
  
  /**
   * Set the <code>in8</code> property.
   * @see javax.baja.control.BStringWritable#in8
   */
  public void setIn8(BStatusString v) { set(in8,v,null); }

////////////////////////////////////////////////////////////////
// Property "in9"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in9</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn9
   * @see javax.baja.control.BStringWritable#setIn9
   */
  public static final Property in9 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in9</code> property.
   * @see javax.baja.control.BStringWritable#in9
   */
  public BStatusString getIn9() { return (BStatusString)get(in9); }
  
  /**
   * Set the <code>in9</code> property.
   * @see javax.baja.control.BStringWritable#in9
   */
  public void setIn9(BStatusString v) { set(in9,v,null); }

////////////////////////////////////////////////////////////////
// Property "in10"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in10</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn10
   * @see javax.baja.control.BStringWritable#setIn10
   */
  public static final Property in10 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in10</code> property.
   * @see javax.baja.control.BStringWritable#in10
   */
  public BStatusString getIn10() { return (BStatusString)get(in10); }
  
  /**
   * Set the <code>in10</code> property.
   * @see javax.baja.control.BStringWritable#in10
   */
  public void setIn10(BStatusString v) { set(in10,v,null); }

////////////////////////////////////////////////////////////////
// Property "in11"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in11</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn11
   * @see javax.baja.control.BStringWritable#setIn11
   */
  public static final Property in11 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in11</code> property.
   * @see javax.baja.control.BStringWritable#in11
   */
  public BStatusString getIn11() { return (BStatusString)get(in11); }
  
  /**
   * Set the <code>in11</code> property.
   * @see javax.baja.control.BStringWritable#in11
   */
  public void setIn11(BStatusString v) { set(in11,v,null); }

////////////////////////////////////////////////////////////////
// Property "in12"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in12</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn12
   * @see javax.baja.control.BStringWritable#setIn12
   */
  public static final Property in12 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in12</code> property.
   * @see javax.baja.control.BStringWritable#in12
   */
  public BStatusString getIn12() { return (BStatusString)get(in12); }
  
  /**
   * Set the <code>in12</code> property.
   * @see javax.baja.control.BStringWritable#in12
   */
  public void setIn12(BStatusString v) { set(in12,v,null); }

////////////////////////////////////////////////////////////////
// Property "in13"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in13</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn13
   * @see javax.baja.control.BStringWritable#setIn13
   */
  public static final Property in13 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in13</code> property.
   * @see javax.baja.control.BStringWritable#in13
   */
  public BStatusString getIn13() { return (BStatusString)get(in13); }
  
  /**
   * Set the <code>in13</code> property.
   * @see javax.baja.control.BStringWritable#in13
   */
  public void setIn13(BStatusString v) { set(in13,v,null); }

////////////////////////////////////////////////////////////////
// Property "in14"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in14</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn14
   * @see javax.baja.control.BStringWritable#setIn14
   */
  public static final Property in14 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in14</code> property.
   * @see javax.baja.control.BStringWritable#in14
   */
  public BStatusString getIn14() { return (BStatusString)get(in14); }
  
  /**
   * Set the <code>in14</code> property.
   * @see javax.baja.control.BStringWritable#in14
   */
  public void setIn14(BStatusString v) { set(in14,v,null); }

////////////////////////////////////////////////////////////////
// Property "in15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in15</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn15
   * @see javax.baja.control.BStringWritable#setIn15
   */
  public static final Property in15 = newProperty(Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in15</code> property.
   * @see javax.baja.control.BStringWritable#in15
   */
  public BStatusString getIn15() { return (BStatusString)get(in15); }
  
  /**
   * Set the <code>in15</code> property.
   * @see javax.baja.control.BStringWritable#in15
   */
  public void setIn15(BStatusString v) { set(in15,v,null); }

////////////////////////////////////////////////////////////////
// Property "in16"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in16</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BStringWritable#getIn16
   * @see javax.baja.control.BStringWritable#setIn16
   */
  public static final Property in16 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>in16</code> property.
   * @see javax.baja.control.BStringWritable#in16
   */
  public BStatusString getIn16() { return (BStatusString)get(in16); }
  
  /**
   * Set the <code>in16</code> property.
   * @see javax.baja.control.BStringWritable#in16
   */
  public void setIn16(BStatusString v) { set(in16,v,null); }

////////////////////////////////////////////////////////////////
// Property "fallback"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fallback</code> property.
   * This is the value to use if none of the levels are
   * valid.
   * @see javax.baja.control.BStringWritable#getFallback
   * @see javax.baja.control.BStringWritable#setFallback
   */
  public static final Property fallback = newProperty(0, new BStatusString("", BStatus.nullStatus),null);
  
  /**
   * Get the <code>fallback</code> property.
   * @see javax.baja.control.BStringWritable#fallback
   */
  public BStatusString getFallback() { return (BStatusString)get(fallback); }
  
  /**
   * Set the <code>fallback</code> property.
   * @see javax.baja.control.BStringWritable#fallback
   */
  public void setFallback(BStatusString v) { set(fallback,v,null); }

////////////////////////////////////////////////////////////////
// Property "overrideExpiration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>overrideExpiration</code> property.
   * Time which override will expire
   * @see javax.baja.control.BStringWritable#getOverrideExpiration
   * @see javax.baja.control.BStringWritable#setOverrideExpiration
   */
  public static final Property overrideExpiration = newProperty(Flags.OPERATOR|Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BStringWritable#overrideExpiration
   */
  public BAbsTime getOverrideExpiration() { return (BAbsTime)get(overrideExpiration); }
  
  /**
   * Set the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BStringWritable#overrideExpiration
   */
  public void setOverrideExpiration(BAbsTime v) { set(overrideExpiration,v,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyOverride"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyOverride</code> action.
   * To set an output value at the Emergency level (1).
   * @see javax.baja.control.BStringWritable#emergencyOverride()
   */
  public static final Action emergencyOverride = newAction(0,BString.make(""),null);
  
  /**
   * Invoke the <code>emergencyOverride</code> action.
   * @see javax.baja.control.BStringWritable#emergencyOverride
   */
  public void emergencyOverride(BString arg) { invoke(emergencyOverride,arg,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyAuto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyAuto</code> action.
   * To clear an output value set at the Emergency level
   * (1).
   * @see javax.baja.control.BStringWritable#emergencyAuto()
   */
  public static final Action emergencyAuto = newAction(0,null);
  
  /**
   * Invoke the <code>emergencyAuto</code> action.
   * @see javax.baja.control.BStringWritable#emergencyAuto
   */
  public void emergencyAuto() { invoke(emergencyAuto,null,null); }

////////////////////////////////////////////////////////////////
// Action "override"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>override</code> action.
   * To set an output value at the Manual level (8).
   * @see javax.baja.control.BStringWritable#override()
   */
  public static final Action override = newAction(Flags.OPERATOR,new BStringOverride(),null);
  
  /**
   * Invoke the <code>override</code> action.
   * @see javax.baja.control.BStringWritable#override
   */
  public void override(BStringOverride arg) { invoke(override,arg,null); }

////////////////////////////////////////////////////////////////
// Action "auto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>auto</code> action.
   * To clear an output value set at the Manual level (8).
   * @see javax.baja.control.BStringWritable#auto()
   */
  public static final Action auto = newAction(Flags.OPERATOR,null);
  
  /**
   * Invoke the <code>auto</code> action.
   * @see javax.baja.control.BStringWritable#auto
   */
  public void auto() { invoke(auto,null,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * Set the fallback property value.
   * @see javax.baja.control.BStringWritable#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BString.DEFAULT,null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see javax.baja.control.BStringWritable#set
   */
  public void set(BString arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringWritable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////

  public void started()
  throws Exception
  {
    super.started();
    support.started();
  }

  public final boolean isWritablePoint()
  {
    return true;
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) return getFallback().getValueValue();
    if (action == override)
    {
      BStringOverride o = new BStringOverride(support.getMaxOverrideDuration(),getOut().getValue());
      o.setMaxOverrideDuration(support.getMaxOverrideDuration());
      return o;
    }
    if (action == emergencyOverride) return getOut().getValueValue();
    return super.getActionParameterDefault(action);
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if (support.isInput(slot) ||
        slot == fallback ||
        slot == override ||
        slot == emergencyOverride ||
        slot == set)
      return getFacets();

    return super.getSlotFacets(slot);
  }

  public void onExecute(BStatusValue o, Context cx)
  {
    support.onExecute(o, cx);
  }

  WritableSupport writableSupport()
  {
    return support;
  }

////////////////////////////////////////////////////////////////
// IWritablePoint
////////////////////////////////////////////////////////////////

  public final BPriorityLevel getActiveLevel()
  {
    return support.getActiveLevel();
  }

  public final BStatusValue getInStatusValue(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal());
  }

  public final Property getInProperty(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal()).getPropertyInParent();
  }

  public final BStatusString getLevel(BPriorityLevel level)
  {
    return (BStatusString)support.getLevel(level.getOrdinal());
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public void doEmergencyOverride(BString v)
  {
    support.emergencyOverride(v);
  }

  public void doEmergencyAuto()
  {
    support.emergencyAuto();
  }

  public void doOverride(BStringOverride v)
  {
    support.override(v);
  }

  public void doAuto()
  {
    support.auto();
  }

  public void doSet(BString v)
  {
    support.set(v);
  }

  /**
   * Callback when the given Action is invoked with the given argument and Context. Overridden
   * here to check if the given Context has a non-null user (indicating server-side handling of
   * a user-invoked Action) and the action is a {@link #set}, {@link #override}, or
   * {@link #emergencyOverride}. If so, then a String length check is optionally performed against
   * the action argument if any MIN/MAX facets are specified for the value of this point.
   *
   * @since Niagara 4.10u8
   */
  @Override
  void fwCheckActionInvocation(Action action, BValue arg, Context context)
  {
    if (!ObjectUtil.SERVER_MIN_MAX_CHECK_DISABLED && context != null && context.getUser() != null &&
        (action.equals(set) || action.equals(override) || action.equals(emergencyOverride)))
    {
      ObjectUtil.checkMinMaxFacetsOnValue(
        arg instanceof BStringOverride ? arg.asComplex().get(BStringOverride.value) : arg,
        getSlotFacets(action), context
      );
    }
  }

////////////////////////////////////////////////////////////////
// WritableSupport
////////////////////////////////////////////////////////////////

  final class StringWritableSupport extends WritableSupport
  {
    StringWritableSupport(BStringWritable pt) { super(pt); }

    Property in1()  { return in1; }
    Property in2()  { return in2; }
    Property in3()  { return in3; }
    Property in4()  { return in4; }
    Property in5()  { return in5; }
    Property in6()  { return in6; }
    Property in7()  { return in7; }
    Property in8()  { return in8; }
    Property in9()  { return in9; }
    Property in10() { return in10; }
    Property in11() { return in11; }
    Property in12() { return in12; }
    Property in13() { return in13; }
    Property in14() { return in14; }
    Property in15() { return in15; }
    Property in16() { return in16; }

    BStatusValue getFallback()
    {
      return BStringWritable.this.getFallback();
    }

    void setOverrideExpiration(BAbsTime time)
    {
      BStringWritable.this.setOverrideExpiration(time);
    }

    BAbsTime getOverrideExpiration()
    {
      return BStringWritable.this.getOverrideExpiration();
    }

    void setValue(BStatusValue from, BStatusValue to)
    {
      ((BStatusString)to).setValue( ((BStatusString)from).getValue() );
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  WritableSupport support = new StringWritableSupport(this);
}
