/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BStringPoint defines a read only string control point.
 *
 * @author    Craig Gemmill
 * @creation  11 Feb 02
 * @version   $Revision: 13$ $Date: 3/28/05 11:40:32 AM EST$
 * @since     Baja 1.0
 */
public class BStringPoint
  extends BControlPoint
{

  public static final Property facets = newProperty(0, BFacets.DEFAULT);

  /*-

  class BStringPoint
  {
    properties
    {
      out: BStatusString
        -- The out slot of a BStringPoint is a
        -- BStatusString
        flags { operator, readonly, transient, summary }
        default {[ new BStatusString() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BStringPoint(3807546091)1.0$ @*/
/* Generated Thu Feb 06 09:52:18 EST 2003 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The out slot of a BStringPoint is a BStatusString
   * @see javax.baja.control.BStringPoint#getOut
   * @see javax.baja.control.BStringPoint#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see javax.baja.control.BStringPoint#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see javax.baja.control.BStringPoint#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringPoint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Get the control output element.
   */
  public final BStatusValue getOutStatusValue() { return getOut(); }

  /**
   * Get the string output value.
   */
  public final BStatusString getOutStatusString() { return getOut(); }

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////

  /**
   * Default implementation is to do nothing.
   */
  public void onExecute(BStatusValue out, Context cx)
  {
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  /**
   * Get the icon.
   */
  public BIcon getIcon() 
  { 
    BValue dynamic = get("icon");
    if (dynamic instanceof BIcon)
      return (BIcon)dynamic;
    return icon; 
  }
  private static final BIcon icon = BIcon.std("control/stringPoint.png");

}
