/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BNumericOverride;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.util.ObjectUtil;

/**
 * BNumericWritable defines a writable control point with 16 input levels.
 *
 * @author    Dan Giorgis
 * @creation  30 Oct 00
 * @version   $Revision: 36$ $Date: 7/27/10 12:19:14 PM EDT$
 * @since     Baja 1.0
 */
public class BNumericWritable
  extends BNumericPoint
  implements BIWritablePoint
{

  /*-

  class BNumericWritable
  {
    properties
    {
      in1: BStatusNumeric
        -- The last command at this priority level.
        -- Commands at emergency level 1 are persisted
        flags { readonly }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in2: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in3: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in4: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in5: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in6: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in7: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in8: BStatusNumeric
        -- The last command at this priority level.
        -- Commands at manual level 8 are persisted
        flags { readonly }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in9: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in10: BStatusNumeric
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in11: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in12: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in13: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in14: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in15: BStatusNumeric
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      in16: BStatusNumeric
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}

      fallback: BStatusNumeric
        -- This is the value to use if none of the levels are valid.
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}

      overrideExpiration: BAbsTime
        -- Time which override will expire
        flags { operator, readonly }
        default {[ BAbsTime.NULL ]}
    }

    actions
    {
      emergencyOverride(arg: BDouble)
        -- To set an output value at the Emergency level (1).
        default {[ BDouble.DEFAULT ]}
      emergencyAuto()
        -- To clear an output value set at the Emergency level (1).

      override(arg: BNumericOverride)
        -- To set an output value at the Manual level (8).
        flags { operator }
        default {[ new BNumericOverride() ]}
      auto()
        -- To clear an output value set at the Manual level (8).
        flags { operator }

      set(arg: BDouble)
        -- Set the fallback property value.
        flags { operator }
        default {[ BDouble.DEFAULT ]}
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BNumericWritable(1516749260)1.0$ @*/
/* Generated Tue Jun 22 13:23:20 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "in1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in1</code> property.
   * The last command at this priority level. Commands at emergency level 1 are persisted
   * @see javax.baja.control.BNumericWritable#getIn1
   * @see javax.baja.control.BNumericWritable#setIn1
   */
  public static final Property in1 = newProperty(Flags.READONLY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in1</code> property.
   * @see javax.baja.control.BNumericWritable#in1
   */
  public BStatusNumeric getIn1() { return (BStatusNumeric)get(in1); }
  
  /**
   * Set the <code>in1</code> property.
   * @see javax.baja.control.BNumericWritable#in1
   */
  public void setIn1(BStatusNumeric v) { set(in1,v,null); }

////////////////////////////////////////////////////////////////
// Property "in2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in2</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn2
   * @see javax.baja.control.BNumericWritable#setIn2
   */
  public static final Property in2 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in2</code> property.
   * @see javax.baja.control.BNumericWritable#in2
   */
  public BStatusNumeric getIn2() { return (BStatusNumeric)get(in2); }
  
  /**
   * Set the <code>in2</code> property.
   * @see javax.baja.control.BNumericWritable#in2
   */
  public void setIn2(BStatusNumeric v) { set(in2,v,null); }

////////////////////////////////////////////////////////////////
// Property "in3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in3</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn3
   * @see javax.baja.control.BNumericWritable#setIn3
   */
  public static final Property in3 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in3</code> property.
   * @see javax.baja.control.BNumericWritable#in3
   */
  public BStatusNumeric getIn3() { return (BStatusNumeric)get(in3); }
  
  /**
   * Set the <code>in3</code> property.
   * @see javax.baja.control.BNumericWritable#in3
   */
  public void setIn3(BStatusNumeric v) { set(in3,v,null); }

////////////////////////////////////////////////////////////////
// Property "in4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in4</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn4
   * @see javax.baja.control.BNumericWritable#setIn4
   */
  public static final Property in4 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in4</code> property.
   * @see javax.baja.control.BNumericWritable#in4
   */
  public BStatusNumeric getIn4() { return (BStatusNumeric)get(in4); }
  
  /**
   * Set the <code>in4</code> property.
   * @see javax.baja.control.BNumericWritable#in4
   */
  public void setIn4(BStatusNumeric v) { set(in4,v,null); }

////////////////////////////////////////////////////////////////
// Property "in5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in5</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn5
   * @see javax.baja.control.BNumericWritable#setIn5
   */
  public static final Property in5 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in5</code> property.
   * @see javax.baja.control.BNumericWritable#in5
   */
  public BStatusNumeric getIn5() { return (BStatusNumeric)get(in5); }
  
  /**
   * Set the <code>in5</code> property.
   * @see javax.baja.control.BNumericWritable#in5
   */
  public void setIn5(BStatusNumeric v) { set(in5,v,null); }

////////////////////////////////////////////////////////////////
// Property "in6"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in6</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn6
   * @see javax.baja.control.BNumericWritable#setIn6
   */
  public static final Property in6 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in6</code> property.
   * @see javax.baja.control.BNumericWritable#in6
   */
  public BStatusNumeric getIn6() { return (BStatusNumeric)get(in6); }
  
  /**
   * Set the <code>in6</code> property.
   * @see javax.baja.control.BNumericWritable#in6
   */
  public void setIn6(BStatusNumeric v) { set(in6,v,null); }

////////////////////////////////////////////////////////////////
// Property "in7"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in7</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn7
   * @see javax.baja.control.BNumericWritable#setIn7
   */
  public static final Property in7 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in7</code> property.
   * @see javax.baja.control.BNumericWritable#in7
   */
  public BStatusNumeric getIn7() { return (BStatusNumeric)get(in7); }
  
  /**
   * Set the <code>in7</code> property.
   * @see javax.baja.control.BNumericWritable#in7
   */
  public void setIn7(BStatusNumeric v) { set(in7,v,null); }

////////////////////////////////////////////////////////////////
// Property "in8"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in8</code> property.
   * The last command at this priority level. Commands at manual level 8 are persisted
   * @see javax.baja.control.BNumericWritable#getIn8
   * @see javax.baja.control.BNumericWritable#setIn8
   */
  public static final Property in8 = newProperty(Flags.READONLY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in8</code> property.
   * @see javax.baja.control.BNumericWritable#in8
   */
  public BStatusNumeric getIn8() { return (BStatusNumeric)get(in8); }
  
  /**
   * Set the <code>in8</code> property.
   * @see javax.baja.control.BNumericWritable#in8
   */
  public void setIn8(BStatusNumeric v) { set(in8,v,null); }

////////////////////////////////////////////////////////////////
// Property "in9"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in9</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn9
   * @see javax.baja.control.BNumericWritable#setIn9
   */
  public static final Property in9 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in9</code> property.
   * @see javax.baja.control.BNumericWritable#in9
   */
  public BStatusNumeric getIn9() { return (BStatusNumeric)get(in9); }
  
  /**
   * Set the <code>in9</code> property.
   * @see javax.baja.control.BNumericWritable#in9
   */
  public void setIn9(BStatusNumeric v) { set(in9,v,null); }

////////////////////////////////////////////////////////////////
// Property "in10"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in10</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn10
   * @see javax.baja.control.BNumericWritable#setIn10
   */
  public static final Property in10 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in10</code> property.
   * @see javax.baja.control.BNumericWritable#in10
   */
  public BStatusNumeric getIn10() { return (BStatusNumeric)get(in10); }
  
  /**
   * Set the <code>in10</code> property.
   * @see javax.baja.control.BNumericWritable#in10
   */
  public void setIn10(BStatusNumeric v) { set(in10,v,null); }

////////////////////////////////////////////////////////////////
// Property "in11"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in11</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn11
   * @see javax.baja.control.BNumericWritable#setIn11
   */
  public static final Property in11 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in11</code> property.
   * @see javax.baja.control.BNumericWritable#in11
   */
  public BStatusNumeric getIn11() { return (BStatusNumeric)get(in11); }
  
  /**
   * Set the <code>in11</code> property.
   * @see javax.baja.control.BNumericWritable#in11
   */
  public void setIn11(BStatusNumeric v) { set(in11,v,null); }

////////////////////////////////////////////////////////////////
// Property "in12"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in12</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn12
   * @see javax.baja.control.BNumericWritable#setIn12
   */
  public static final Property in12 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in12</code> property.
   * @see javax.baja.control.BNumericWritable#in12
   */
  public BStatusNumeric getIn12() { return (BStatusNumeric)get(in12); }
  
  /**
   * Set the <code>in12</code> property.
   * @see javax.baja.control.BNumericWritable#in12
   */
  public void setIn12(BStatusNumeric v) { set(in12,v,null); }

////////////////////////////////////////////////////////////////
// Property "in13"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in13</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn13
   * @see javax.baja.control.BNumericWritable#setIn13
   */
  public static final Property in13 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in13</code> property.
   * @see javax.baja.control.BNumericWritable#in13
   */
  public BStatusNumeric getIn13() { return (BStatusNumeric)get(in13); }
  
  /**
   * Set the <code>in13</code> property.
   * @see javax.baja.control.BNumericWritable#in13
   */
  public void setIn13(BStatusNumeric v) { set(in13,v,null); }

////////////////////////////////////////////////////////////////
// Property "in14"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in14</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn14
   * @see javax.baja.control.BNumericWritable#setIn14
   */
  public static final Property in14 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in14</code> property.
   * @see javax.baja.control.BNumericWritable#in14
   */
  public BStatusNumeric getIn14() { return (BStatusNumeric)get(in14); }
  
  /**
   * Set the <code>in14</code> property.
   * @see javax.baja.control.BNumericWritable#in14
   */
  public void setIn14(BStatusNumeric v) { set(in14,v,null); }

////////////////////////////////////////////////////////////////
// Property "in15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in15</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn15
   * @see javax.baja.control.BNumericWritable#setIn15
   */
  public static final Property in15 = newProperty(Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in15</code> property.
   * @see javax.baja.control.BNumericWritable#in15
   */
  public BStatusNumeric getIn15() { return (BStatusNumeric)get(in15); }
  
  /**
   * Set the <code>in15</code> property.
   * @see javax.baja.control.BNumericWritable#in15
   */
  public void setIn15(BStatusNumeric v) { set(in15,v,null); }

////////////////////////////////////////////////////////////////
// Property "in16"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in16</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BNumericWritable#getIn16
   * @see javax.baja.control.BNumericWritable#setIn16
   */
  public static final Property in16 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in16</code> property.
   * @see javax.baja.control.BNumericWritable#in16
   */
  public BStatusNumeric getIn16() { return (BStatusNumeric)get(in16); }
  
  /**
   * Set the <code>in16</code> property.
   * @see javax.baja.control.BNumericWritable#in16
   */
  public void setIn16(BStatusNumeric v) { set(in16,v,null); }

////////////////////////////////////////////////////////////////
// Property "fallback"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fallback</code> property.
   * This is the value to use if none of the levels are
   * valid.
   * @see javax.baja.control.BNumericWritable#getFallback
   * @see javax.baja.control.BNumericWritable#setFallback
   */
  public static final Property fallback = newProperty(0, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>fallback</code> property.
   * @see javax.baja.control.BNumericWritable#fallback
   */
  public BStatusNumeric getFallback() { return (BStatusNumeric)get(fallback); }
  
  /**
   * Set the <code>fallback</code> property.
   * @see javax.baja.control.BNumericWritable#fallback
   */
  public void setFallback(BStatusNumeric v) { set(fallback,v,null); }

////////////////////////////////////////////////////////////////
// Property "overrideExpiration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>overrideExpiration</code> property.
   * Time which override will expire
   * @see javax.baja.control.BNumericWritable#getOverrideExpiration
   * @see javax.baja.control.BNumericWritable#setOverrideExpiration
   */
  public static final Property overrideExpiration = newProperty(Flags.OPERATOR|Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BNumericWritable#overrideExpiration
   */
  public BAbsTime getOverrideExpiration() { return (BAbsTime)get(overrideExpiration); }
  
  /**
   * Set the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BNumericWritable#overrideExpiration
   */
  public void setOverrideExpiration(BAbsTime v) { set(overrideExpiration,v,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyOverride"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyOverride</code> action.
   * To set an output value at the Emergency level (1).
   * @see javax.baja.control.BNumericWritable#emergencyOverride()
   */
  public static final Action emergencyOverride = newAction(0,BDouble.DEFAULT,null);
  
  /**
   * Invoke the <code>emergencyOverride</code> action.
   * @see javax.baja.control.BNumericWritable#emergencyOverride
   */
  public void emergencyOverride(BDouble arg) { invoke(emergencyOverride,arg,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyAuto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyAuto</code> action.
   * To clear an output value set at the Emergency level
   * (1).
   * @see javax.baja.control.BNumericWritable#emergencyAuto()
   */
  public static final Action emergencyAuto = newAction(0,null);
  
  /**
   * Invoke the <code>emergencyAuto</code> action.
   * @see javax.baja.control.BNumericWritable#emergencyAuto
   */
  public void emergencyAuto() { invoke(emergencyAuto,null,null); }

////////////////////////////////////////////////////////////////
// Action "override"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>override</code> action.
   * To set an output value at the Manual level (8).
   * @see javax.baja.control.BNumericWritable#override()
   */
  public static final Action override = newAction(Flags.OPERATOR,new BNumericOverride(),null);
  
  /**
   * Invoke the <code>override</code> action.
   * @see javax.baja.control.BNumericWritable#override
   */
  public void override(BNumericOverride arg) { invoke(override,arg,null); }

////////////////////////////////////////////////////////////////
// Action "auto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>auto</code> action.
   * To clear an output value set at the Manual level (8).
   * @see javax.baja.control.BNumericWritable#auto()
   */
  public static final Action auto = newAction(Flags.OPERATOR,null);
  
  /**
   * Invoke the <code>auto</code> action.
   * @see javax.baja.control.BNumericWritable#auto
   */
  public void auto() { invoke(auto,null,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * Set the fallback property value.
   * @see javax.baja.control.BNumericWritable#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BDouble.DEFAULT,null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see javax.baja.control.BNumericWritable#set
   */
  public void set(BDouble arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericWritable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////

  public void started()
  throws Exception
  {
    super.started();
    support.started();
  }

  public final boolean isWritablePoint()
  {
    return true;
  }

  public BValue getActionParameterDefault(Action action)
  {
    BNumber value = null;
    if (action == set)
      value = (BNumber)(getFallback().getValueValue());
    else if ((action == override) || (action == emergencyOverride))
      value = (BNumber)(getOut().getValueValue());

    if (value != null)
    { // check min and max facets, and if the default value is already out of range
      // (can happen on control points, refer to pacman issue 15928), then
      // use the min or max value as the result instead.

      double min = Double.NEGATIVE_INFINITY;
      double max = Double.POSITIVE_INFINITY;
      double v = value.getDouble();

      // extract facets
      BFacets facets = getFacets();

      BNumber minFacet = (BNumber)facets.getFacet(BFacets.MIN);
      if (minFacet != null) min = minFacet.getDouble();

      BNumber maxFacet = (BNumber)facets.getFacet(BFacets.MAX);
      if (maxFacet != null) max = maxFacet.getDouble();

      if ((minFacet != null) && (v < min))
        value = BDouble.make(min);
      else if ((maxFacet != null) && (v > max))
        value = BDouble.make(max);
    }

    if (action == override)
    {
      BNumericOverride o = new BNumericOverride(support.getMaxOverrideDuration(),value.getDouble());
      o.setMaxOverrideDuration(support.getMaxOverrideDuration());
      return o;
    }
    else if ((action == set) || (action == emergencyOverride)) return value;

    return super.getActionParameterDefault(action);
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if (support.isInput(slot) ||
        slot == fallback ||
        slot == override ||
        slot == emergencyOverride ||
        slot == set)
      return getFacets();

    return super.getSlotFacets(slot);
  }

  public void onExecute(BStatusValue o, Context cx)
  {
    support.onExecute(o, cx);
  }

  WritableSupport writableSupport()
  {
    return support;
  }

////////////////////////////////////////////////////////////////
// IWritablePoint
////////////////////////////////////////////////////////////////

  public final BPriorityLevel getActiveLevel()
  {
    return support.getActiveLevel();
  }

  public final BStatusValue getInStatusValue(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal());
  }

  public final Property getInProperty(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal()).getPropertyInParent();
  }

  public final BStatusNumeric getLevel(BPriorityLevel level)
  {
    return (BStatusNumeric)support.getLevel(level.getOrdinal());
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public void doEmergencyOverride(BDouble v)
  {
    support.emergencyOverride(v);
  }

  public void doEmergencyAuto()
  {
    support.emergencyAuto();
  }

  public void doOverride(BNumericOverride v)
  {
    support.override(v);
  }

  public void doAuto()
  {
    support.auto();
  }

  public void doSet(BDouble v)
  {
    support.set(v);
  }

  /**
   * Callback when the given Action is invoked with the given argument and Context. Overridden
   * here to check if the given Context has a non-null user (indicating server-side handling of
   * a user-invoked Action) and the action is a {@link #set}, {@link #override}, or
   * {@link #emergencyOverride}. If so, then a range check is optionally performed against the
   * action argument if any MIN/MAX facets are specified for the value of this point.
   *
   * @since Niagara 4.10u8
   */
  @Override
  void fwCheckActionInvocation(Action action, BValue arg, Context context)
  {
    if (!ObjectUtil.SERVER_MIN_MAX_CHECK_DISABLED && context != null && context.getUser() != null &&
       (action.equals(set) || action.equals(override) || action.equals(emergencyOverride)))
    {
      ObjectUtil.checkMinMaxFacetsOnValue(
        arg instanceof BNumericOverride ? arg.asComplex().get(BNumericOverride.value) : arg,
        getSlotFacets(action), context
      );
    }
  }

////////////////////////////////////////////////////////////////
// WritableSupport
////////////////////////////////////////////////////////////////

  final class NumericWritableSupport extends WritableSupport
  {
    NumericWritableSupport(BNumericWritable pt) { super(pt); }

    Property in1()  { return in1; }
    Property in2()  { return in2; }
    Property in3()  { return in3; }
    Property in4()  { return in4; }
    Property in5()  { return in5; }
    Property in6()  { return in6; }
    Property in7()  { return in7; }
    Property in8()  { return in8; }
    Property in9()  { return in9; }
    Property in10() { return in10; }
    Property in11() { return in11; }
    Property in12() { return in12; }
    Property in13() { return in13; }
    Property in14() { return in14; }
    Property in15() { return in15; }
    Property in16() { return in16; }

    BStatusValue getFallback()
    {
      return BNumericWritable.this.getFallback();
    }

    void setOverrideExpiration(BAbsTime time)
    {
      BNumericWritable.this.setOverrideExpiration(time);
    }

    BAbsTime getOverrideExpiration()
    {
      return BNumericWritable.this.getOverrideExpiration();
    }

    void setValue(BStatusValue from, BStatusValue to)
    {
      ((BStatusNumeric)to).setValue( ((BStatusNumeric)from).getValue() );
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  WritableSupport support = new NumericWritableSupport(this);
}
