/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.sys.BIEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BDiscretePoint is the superclass of BBooleanPoint and BEnumPoint.
 *
 * @author    Brian Frank
 * @creation  20 Jan 04
 * @version   $Revision: 3$ $Date: 3/28/05 11:40:31 AM EST$
 * @since     Baja 1.0
 */
public abstract class BDiscretePoint
  extends BControlPoint
  implements BIEnum
{ 
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDiscretePoint.class);

  /**
   * Is the discrete point active.
   */
  public abstract boolean isActive();
 
}
