/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.control;

import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BBooleanOverride;
import javax.baja.control.util.BOverride;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBooleanWritable defines a writable control point with 16 input levels.
 *
 * @author    Dan Giorgis
 * @creation  02 May 01
 * @version   $Revision: 34$ $Date: 7/27/10 12:19:12 PM EDT$
 * @since     Baja 1.0
 */
public class BBooleanWritable
  extends BBooleanPoint
  implements BIWritablePoint
{

  /*-

  class BBooleanWritable
  {
    properties
    {
      in1: BStatusBoolean
        -- The last command at this priority level.
        -- Commands at emergency level 1 are persisted.
        flags { readonly }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in2: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in3: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in4: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in5: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in6: BStatusBoolean
        -- Level 6 is used for min active/inactive timer.
        flags { transient, readonly }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in7: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in8: BStatusBoolean
        -- The last command at this priority level.
        -- Commands at manual level 8 are persisted.
        flags { readonly }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in9: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in10: BStatusBoolean
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in11: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in12: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in13: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in14: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in15: BStatusBoolean
        -- The last command at this priority level.
        flags { transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      in16: BStatusBoolean
        -- The last command at this priority level.
        flags { summary, transient }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}

      fallback: BStatusBoolean
        -- This is the value to use if none of the levels are valid.
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}

      overrideExpiration: BAbsTime
        -- Time which override will expire
        flags { operator, readonly }
        default {[ BAbsTime.NULL ]}

      minActiveTime: BRelTime
        -- If non-zero then this indicates the min amount of time
        -- to hold the point in the active state using level 6.
        default {[ BRelTime.make(0) ]}
      minInactiveTime: BRelTime
        -- If non-zero then this indicates the min amount of time
        -- to hold the point in the inactive state using level 6.
        default {[ BRelTime.make(0) ]}
      setMinInactiveTimeOnStart: boolean
        -- If true, the minInactive timer will be set
        -- on station start.
        default{[ false ]}
    }

    actions
    {
      emergencyActive()
        -- To set an active output at the Emergency level (1).
      emergencyInactive()
        -- To set an inactive output at the Emergency level (1).
      emergencyAuto()
        -- To clear any active or inactive output at the Emergency level (1).

      active(arg: BOverride)
        -- To set an active output at the Manual level (8).
        flags { operator }
        default {[ new BOverride() ]}
      inactive(arg: BOverride)
        -- To set an inactive output at the Manual level (8).
        flags { operator }
        default {[ new BOverride() ]}
      auto()
        -- To clear any active or inactive output at the Manual level (8).
        flags { operator }

      set(arg: BBoolean)
        -- Set the fallback property value.
        flags { operator }
        default {[ BBoolean.FALSE ]}

      cancelMinTimer()
        -- Clears level 6 by setting the null bit.
        flags { hidden }
    }

  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.control.BBooleanWritable(56938294)1.0$ @*/
/* Generated Tue Jun 22 13:23:20 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "in1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in1</code> property.
   * The last command at this priority level. Commands at emergency level 1 are persisted.
   * @see javax.baja.control.BBooleanWritable#getIn1
   * @see javax.baja.control.BBooleanWritable#setIn1
   */
  public static final Property in1 = newProperty(Flags.READONLY, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in1</code> property.
   * @see javax.baja.control.BBooleanWritable#in1
   */
  public BStatusBoolean getIn1() { return (BStatusBoolean)get(in1); }
  
  /**
   * Set the <code>in1</code> property.
   * @see javax.baja.control.BBooleanWritable#in1
   */
  public void setIn1(BStatusBoolean v) { set(in1,v,null); }

////////////////////////////////////////////////////////////////
// Property "in2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in2</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn2
   * @see javax.baja.control.BBooleanWritable#setIn2
   */
  public static final Property in2 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in2</code> property.
   * @see javax.baja.control.BBooleanWritable#in2
   */
  public BStatusBoolean getIn2() { return (BStatusBoolean)get(in2); }
  
  /**
   * Set the <code>in2</code> property.
   * @see javax.baja.control.BBooleanWritable#in2
   */
  public void setIn2(BStatusBoolean v) { set(in2,v,null); }

////////////////////////////////////////////////////////////////
// Property "in3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in3</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn3
   * @see javax.baja.control.BBooleanWritable#setIn3
   */
  public static final Property in3 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in3</code> property.
   * @see javax.baja.control.BBooleanWritable#in3
   */
  public BStatusBoolean getIn3() { return (BStatusBoolean)get(in3); }
  
  /**
   * Set the <code>in3</code> property.
   * @see javax.baja.control.BBooleanWritable#in3
   */
  public void setIn3(BStatusBoolean v) { set(in3,v,null); }

////////////////////////////////////////////////////////////////
// Property "in4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in4</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn4
   * @see javax.baja.control.BBooleanWritable#setIn4
   */
  public static final Property in4 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in4</code> property.
   * @see javax.baja.control.BBooleanWritable#in4
   */
  public BStatusBoolean getIn4() { return (BStatusBoolean)get(in4); }
  
  /**
   * Set the <code>in4</code> property.
   * @see javax.baja.control.BBooleanWritable#in4
   */
  public void setIn4(BStatusBoolean v) { set(in4,v,null); }

////////////////////////////////////////////////////////////////
// Property "in5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in5</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn5
   * @see javax.baja.control.BBooleanWritable#setIn5
   */
  public static final Property in5 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in5</code> property.
   * @see javax.baja.control.BBooleanWritable#in5
   */
  public BStatusBoolean getIn5() { return (BStatusBoolean)get(in5); }
  
  /**
   * Set the <code>in5</code> property.
   * @see javax.baja.control.BBooleanWritable#in5
   */
  public void setIn5(BStatusBoolean v) { set(in5,v,null); }

////////////////////////////////////////////////////////////////
// Property "in6"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in6</code> property.
   * Level 6 is used for min active/inactive timer.
   * @see javax.baja.control.BBooleanWritable#getIn6
   * @see javax.baja.control.BBooleanWritable#setIn6
   */
  public static final Property in6 = newProperty(Flags.TRANSIENT|Flags.READONLY, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in6</code> property.
   * @see javax.baja.control.BBooleanWritable#in6
   */
  public BStatusBoolean getIn6() { return (BStatusBoolean)get(in6); }
  
  /**
   * Set the <code>in6</code> property.
   * @see javax.baja.control.BBooleanWritable#in6
   */
  public void setIn6(BStatusBoolean v) { set(in6,v,null); }

////////////////////////////////////////////////////////////////
// Property "in7"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in7</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn7
   * @see javax.baja.control.BBooleanWritable#setIn7
   */
  public static final Property in7 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in7</code> property.
   * @see javax.baja.control.BBooleanWritable#in7
   */
  public BStatusBoolean getIn7() { return (BStatusBoolean)get(in7); }
  
  /**
   * Set the <code>in7</code> property.
   * @see javax.baja.control.BBooleanWritable#in7
   */
  public void setIn7(BStatusBoolean v) { set(in7,v,null); }

////////////////////////////////////////////////////////////////
// Property "in8"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in8</code> property.
   * The last command at this priority level. Commands at manual level 8 are persisted.
   * @see javax.baja.control.BBooleanWritable#getIn8
   * @see javax.baja.control.BBooleanWritable#setIn8
   */
  public static final Property in8 = newProperty(Flags.READONLY, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in8</code> property.
   * @see javax.baja.control.BBooleanWritable#in8
   */
  public BStatusBoolean getIn8() { return (BStatusBoolean)get(in8); }
  
  /**
   * Set the <code>in8</code> property.
   * @see javax.baja.control.BBooleanWritable#in8
   */
  public void setIn8(BStatusBoolean v) { set(in8,v,null); }

////////////////////////////////////////////////////////////////
// Property "in9"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in9</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn9
   * @see javax.baja.control.BBooleanWritable#setIn9
   */
  public static final Property in9 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in9</code> property.
   * @see javax.baja.control.BBooleanWritable#in9
   */
  public BStatusBoolean getIn9() { return (BStatusBoolean)get(in9); }
  
  /**
   * Set the <code>in9</code> property.
   * @see javax.baja.control.BBooleanWritable#in9
   */
  public void setIn9(BStatusBoolean v) { set(in9,v,null); }

////////////////////////////////////////////////////////////////
// Property "in10"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in10</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn10
   * @see javax.baja.control.BBooleanWritable#setIn10
   */
  public static final Property in10 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in10</code> property.
   * @see javax.baja.control.BBooleanWritable#in10
   */
  public BStatusBoolean getIn10() { return (BStatusBoolean)get(in10); }
  
  /**
   * Set the <code>in10</code> property.
   * @see javax.baja.control.BBooleanWritable#in10
   */
  public void setIn10(BStatusBoolean v) { set(in10,v,null); }

////////////////////////////////////////////////////////////////
// Property "in11"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in11</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn11
   * @see javax.baja.control.BBooleanWritable#setIn11
   */
  public static final Property in11 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in11</code> property.
   * @see javax.baja.control.BBooleanWritable#in11
   */
  public BStatusBoolean getIn11() { return (BStatusBoolean)get(in11); }
  
  /**
   * Set the <code>in11</code> property.
   * @see javax.baja.control.BBooleanWritable#in11
   */
  public void setIn11(BStatusBoolean v) { set(in11,v,null); }

////////////////////////////////////////////////////////////////
// Property "in12"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in12</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn12
   * @see javax.baja.control.BBooleanWritable#setIn12
   */
  public static final Property in12 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in12</code> property.
   * @see javax.baja.control.BBooleanWritable#in12
   */
  public BStatusBoolean getIn12() { return (BStatusBoolean)get(in12); }
  
  /**
   * Set the <code>in12</code> property.
   * @see javax.baja.control.BBooleanWritable#in12
   */
  public void setIn12(BStatusBoolean v) { set(in12,v,null); }

////////////////////////////////////////////////////////////////
// Property "in13"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in13</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn13
   * @see javax.baja.control.BBooleanWritable#setIn13
   */
  public static final Property in13 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in13</code> property.
   * @see javax.baja.control.BBooleanWritable#in13
   */
  public BStatusBoolean getIn13() { return (BStatusBoolean)get(in13); }
  
  /**
   * Set the <code>in13</code> property.
   * @see javax.baja.control.BBooleanWritable#in13
   */
  public void setIn13(BStatusBoolean v) { set(in13,v,null); }

////////////////////////////////////////////////////////////////
// Property "in14"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in14</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn14
   * @see javax.baja.control.BBooleanWritable#setIn14
   */
  public static final Property in14 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in14</code> property.
   * @see javax.baja.control.BBooleanWritable#in14
   */
  public BStatusBoolean getIn14() { return (BStatusBoolean)get(in14); }
  
  /**
   * Set the <code>in14</code> property.
   * @see javax.baja.control.BBooleanWritable#in14
   */
  public void setIn14(BStatusBoolean v) { set(in14,v,null); }

////////////////////////////////////////////////////////////////
// Property "in15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in15</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn15
   * @see javax.baja.control.BBooleanWritable#setIn15
   */
  public static final Property in15 = newProperty(Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in15</code> property.
   * @see javax.baja.control.BBooleanWritable#in15
   */
  public BStatusBoolean getIn15() { return (BStatusBoolean)get(in15); }
  
  /**
   * Set the <code>in15</code> property.
   * @see javax.baja.control.BBooleanWritable#in15
   */
  public void setIn15(BStatusBoolean v) { set(in15,v,null); }

////////////////////////////////////////////////////////////////
// Property "in16"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in16</code> property.
   * The last command at this priority level.
   * @see javax.baja.control.BBooleanWritable#getIn16
   * @see javax.baja.control.BBooleanWritable#setIn16
   */
  public static final Property in16 = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>in16</code> property.
   * @see javax.baja.control.BBooleanWritable#in16
   */
  public BStatusBoolean getIn16() { return (BStatusBoolean)get(in16); }
  
  /**
   * Set the <code>in16</code> property.
   * @see javax.baja.control.BBooleanWritable#in16
   */
  public void setIn16(BStatusBoolean v) { set(in16,v,null); }

////////////////////////////////////////////////////////////////
// Property "fallback"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fallback</code> property.
   * This is the value to use if none of the levels are
   * valid.
   * @see javax.baja.control.BBooleanWritable#getFallback
   * @see javax.baja.control.BBooleanWritable#setFallback
   */
  public static final Property fallback = newProperty(0, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>fallback</code> property.
   * @see javax.baja.control.BBooleanWritable#fallback
   */
  public BStatusBoolean getFallback() { return (BStatusBoolean)get(fallback); }
  
  /**
   * Set the <code>fallback</code> property.
   * @see javax.baja.control.BBooleanWritable#fallback
   */
  public void setFallback(BStatusBoolean v) { set(fallback,v,null); }

////////////////////////////////////////////////////////////////
// Property "overrideExpiration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>overrideExpiration</code> property.
   * Time which override will expire
   * @see javax.baja.control.BBooleanWritable#getOverrideExpiration
   * @see javax.baja.control.BBooleanWritable#setOverrideExpiration
   */
  public static final Property overrideExpiration = newProperty(Flags.OPERATOR|Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BBooleanWritable#overrideExpiration
   */
  public BAbsTime getOverrideExpiration() { return (BAbsTime)get(overrideExpiration); }
  
  /**
   * Set the <code>overrideExpiration</code> property.
   * @see javax.baja.control.BBooleanWritable#overrideExpiration
   */
  public void setOverrideExpiration(BAbsTime v) { set(overrideExpiration,v,null); }

////////////////////////////////////////////////////////////////
// Property "minActiveTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minActiveTime</code> property.
   * If non-zero then this indicates the min amount of time to hold the point in the active state using level 6.
   * @see javax.baja.control.BBooleanWritable#getMinActiveTime
   * @see javax.baja.control.BBooleanWritable#setMinActiveTime
   */
  public static final Property minActiveTime = newProperty(0, BRelTime.make(0),null);
  
  /**
   * Get the <code>minActiveTime</code> property.
   * @see javax.baja.control.BBooleanWritable#minActiveTime
   */
  public BRelTime getMinActiveTime() { return (BRelTime)get(minActiveTime); }
  
  /**
   * Set the <code>minActiveTime</code> property.
   * @see javax.baja.control.BBooleanWritable#minActiveTime
   */
  public void setMinActiveTime(BRelTime v) { set(minActiveTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "minInactiveTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minInactiveTime</code> property.
   * If non-zero then this indicates the min amount of time to hold the point in the inactive state using level 6.
   * @see javax.baja.control.BBooleanWritable#getMinInactiveTime
   * @see javax.baja.control.BBooleanWritable#setMinInactiveTime
   */
  public static final Property minInactiveTime = newProperty(0, BRelTime.make(0),null);
  
  /**
   * Get the <code>minInactiveTime</code> property.
   * @see javax.baja.control.BBooleanWritable#minInactiveTime
   */
  public BRelTime getMinInactiveTime() { return (BRelTime)get(minInactiveTime); }
  
  /**
   * Set the <code>minInactiveTime</code> property.
   * @see javax.baja.control.BBooleanWritable#minInactiveTime
   */
  public void setMinInactiveTime(BRelTime v) { set(minInactiveTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "setMinInactiveTimeOnStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setMinInactiveTimeOnStart</code> property.
   * If true, the minInactive timer will be set on station
   * start.
   * @see javax.baja.control.BBooleanWritable#getSetMinInactiveTimeOnStart
   * @see javax.baja.control.BBooleanWritable#setSetMinInactiveTimeOnStart
   */
  public static final Property setMinInactiveTimeOnStart = newProperty(0, false,null);
  
  /**
   * Get the <code>setMinInactiveTimeOnStart</code> property.
   * @see javax.baja.control.BBooleanWritable#setMinInactiveTimeOnStart
   */
  public boolean getSetMinInactiveTimeOnStart() { return getBoolean(setMinInactiveTimeOnStart); }
  
  /**
   * Set the <code>setMinInactiveTimeOnStart</code> property.
   * @see javax.baja.control.BBooleanWritable#setMinInactiveTimeOnStart
   */
  public void setSetMinInactiveTimeOnStart(boolean v) { setBoolean(setMinInactiveTimeOnStart,v,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyActive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyActive</code> action.
   * To set an active output at the Emergency level (1).
   * @see javax.baja.control.BBooleanWritable#emergencyActive()
   */
  public static final Action emergencyActive = newAction(0,null);
  
  /**
   * Invoke the <code>emergencyActive</code> action.
   * @see javax.baja.control.BBooleanWritable#emergencyActive
   */
  public void emergencyActive() { invoke(emergencyActive,null,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyInactive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyInactive</code> action.
   * To set an inactive output at the Emergency level (1).
   * @see javax.baja.control.BBooleanWritable#emergencyInactive()
   */
  public static final Action emergencyInactive = newAction(0,null);
  
  /**
   * Invoke the <code>emergencyInactive</code> action.
   * @see javax.baja.control.BBooleanWritable#emergencyInactive
   */
  public void emergencyInactive() { invoke(emergencyInactive,null,null); }

////////////////////////////////////////////////////////////////
// Action "emergencyAuto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>emergencyAuto</code> action.
   * To clear any active or inactive output at the Emergency
   * level (1).
   * @see javax.baja.control.BBooleanWritable#emergencyAuto()
   */
  public static final Action emergencyAuto = newAction(0,null);
  
  /**
   * Invoke the <code>emergencyAuto</code> action.
   * @see javax.baja.control.BBooleanWritable#emergencyAuto
   */
  public void emergencyAuto() { invoke(emergencyAuto,null,null); }

////////////////////////////////////////////////////////////////
// Action "active"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>active</code> action.
   * To set an active output at the Manual level (8).
   * @see javax.baja.control.BBooleanWritable#active()
   */
  public static final Action active = newAction(Flags.OPERATOR,new BOverride(),null);
  
  /**
   * Invoke the <code>active</code> action.
   * @see javax.baja.control.BBooleanWritable#active
   */
  public void active(BOverride arg) { invoke(active,arg,null); }

////////////////////////////////////////////////////////////////
// Action "inactive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inactive</code> action.
   * To set an inactive output at the Manual level (8).
   * @see javax.baja.control.BBooleanWritable#inactive()
   */
  public static final Action inactive = newAction(Flags.OPERATOR,new BOverride(),null);
  
  /**
   * Invoke the <code>inactive</code> action.
   * @see javax.baja.control.BBooleanWritable#inactive
   */
  public void inactive(BOverride arg) { invoke(inactive,arg,null); }

////////////////////////////////////////////////////////////////
// Action "auto"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>auto</code> action.
   * To clear any active or inactive output at the Manual
   * level (8).
   * @see javax.baja.control.BBooleanWritable#auto()
   */
  public static final Action auto = newAction(Flags.OPERATOR,null);
  
  /**
   * Invoke the <code>auto</code> action.
   * @see javax.baja.control.BBooleanWritable#auto
   */
  public void auto() { invoke(auto,null,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * Set the fallback property value.
   * @see javax.baja.control.BBooleanWritable#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BBoolean.FALSE,null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see javax.baja.control.BBooleanWritable#set
   */
  public void set(BBoolean arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Action "cancelMinTimer"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cancelMinTimer</code> action.
   * Clears level 6 by setting the null bit.
   * @see javax.baja.control.BBooleanWritable#cancelMinTimer()
   */
  public static final Action cancelMinTimer = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>cancelMinTimer</code> action.
   * @see javax.baja.control.BBooleanWritable#cancelMinTimer
   */
  public void cancelMinTimer() { invoke(cancelMinTimer,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanWritable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////

  public void started()
  throws Exception
  {
    super.started();
    support.started();

    if(getSetMinInactiveTimeOnStart())
    {
      BRelTime minTime = getMinInactiveTime();

      // if > 0 then we have a timer set
      if (minTime.getMillis() > 0)
      {
        // set level 6
        getIn6().setValue(false);
        getIn6().setStatus(BStatus.ok);
        // setup timer to clear
        minTimer = Clock.schedule(this, minTime, cancelMinTimer, null);
      }
    }
  }

  public final boolean isWritablePoint()
  {
    return true;
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) return getFallback().getValueValue();
    if ((action == active) || (action == inactive))
    {
      BOverride o = new BOverride();
      o.setDuration(support.getMaxOverrideDuration()); 
      o.setMaxOverrideDuration(support.getMaxOverrideDuration());
      return o;
    }
    return super.getActionParameterDefault(action);
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if (support.isInput(slot) ||
        slot == fallback ||
        slot == set)
      return getFacets();

    return super.getSlotFacets(slot);
  }

  public void onExecute(BStatusValue o, Context cx)
  {
    support.onExecute(o, cx);

    // check min active/inactive
    boolean nowActive = ((BStatusBoolean)o).getValue();
    if (wasActive != nowActive)
    {
      // cancel existing timer
      if (minTimer != null) minTimer.cancel();

      // get min to hold in current state
      BRelTime minTime;
      if (nowActive)
        minTime = getMinActiveTime();
      else
        minTime = getMinInactiveTime();

      // if > 0 then we have a timer set
      if (minTime.getMillis() > 0)
      {
        // set level 6
        getIn6().setValue(nowActive);
        getIn6().setStatus(BStatus.ok);

        // run thru execute logic again in case
        // level 6 changes the active level
        support.onExecute(o, cx);

        // setup timer to clear
        minTimer = Clock.schedule(this, minTime, cancelMinTimer, null);
      }

      // save "now" as "was"
      wasActive = nowActive;
    }
  }

  WritableSupport writableSupport()
  {
    return support;
  }

////////////////////////////////////////////////////////////////
// IWritablePoint
////////////////////////////////////////////////////////////////

  public final BPriorityLevel getActiveLevel()
  {
    return support.getActiveLevel();
  }

  public final BStatusValue getInStatusValue(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal());
  }

  public final Property getInProperty(BPriorityLevel level)
  {
    return support.getLevel(level.getOrdinal()).getPropertyInParent();
  }

  public final BStatusBoolean getLevel(BPriorityLevel level)
  {
    return (BStatusBoolean)support.getLevel(level.getOrdinal());
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public void doEmergencyActive()
  {
    support.emergencyOverride(BBoolean.TRUE);
  }

  public void doEmergencyInactive()
  {
    support.emergencyOverride(BBoolean.FALSE);
  }

  public void doEmergencyAuto()
  {
    support.emergencyAuto();
  }

  public void doActive(BOverride override)
  {
    support.override(new BBooleanOverride(override.getDuration(), true));
  }

  public void doInactive(BOverride override)
  {
    support.override(new BBooleanOverride(override.getDuration(), false));
  }

  public void doAuto()
  {
    support.auto();
  }

  public void doSet(BBoolean v)
  {
    support.set(v);
  }

  public void doCancelMinTimer()
  {
    getIn6().setStatus(BStatus.nullStatus);
  }

////////////////////////////////////////////////////////////////
// WritableSupport
////////////////////////////////////////////////////////////////

  final class BooleanWritableSupport extends WritableSupport
  {
    BooleanWritableSupport(BBooleanWritable pt) { super(pt); }

    Property in1()  { return in1; }
    Property in2()  { return in2; }
    Property in3()  { return in3; }
    Property in4()  { return in4; }
    Property in5()  { return in5; }
    Property in6()  { return in6; }
    Property in7()  { return in7; }
    Property in8()  { return in8; }
    Property in9()  { return in9; }
    Property in10() { return in10; }
    Property in11() { return in11; }
    Property in12() { return in12; }
    Property in13() { return in13; }
    Property in14() { return in14; }
    Property in15() { return in15; }
    Property in16() { return in16; }

    BStatusValue getFallback()
    {
      return BBooleanWritable.this.getFallback();
    }

    void setOverrideExpiration(BAbsTime time)
    {
      BBooleanWritable.this.setOverrideExpiration(time);
    }

    BAbsTime getOverrideExpiration()
    {
      return BBooleanWritable.this.getOverrideExpiration();
    }

    void setValue(BStatusValue from, BStatusValue to)
    {
      ((BStatusBoolean)to).setValue( ((BStatusBoolean)from).getValue() );
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  WritableSupport support = new BooleanWritableSupport(this);

  boolean wasActive;
  Clock.Ticket minTimer;
}
