/*
 * Copyright 2012 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.box;

import javax.baja.agent.BIAgent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 * A BOX Type Ext is a Type used to extend the BOX Client's Type System.
 * 
 * 
 * @author    gjohnson
 * @creation  27 Jan 2011
 * @version   1
 * @since     Niagara 3.8
 */
public interface BIBoxTypeExt
    extends BIAgent
{
  Type TYPE = Sys.loadType(BIBoxTypeExt.class);
  
  /**
   * Return the client environment for the Box Type Extension.
   * 
   * @return client environment name
   */
  BBoxClientEnv getClientEnv();
  
  /**
   * Encode the Type Extension to JSON.
   */
  Object encodeToJson(Context cx) throws Exception;
}
