/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.util;

import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.basicdriver.BBasicNetwork;

/**
 * BBasicPollScheduler handles subscribing, unsubscribing, and polling
 * of BIBasicPollable objects.
 *
 * @author    Scott Hoye
 * @creation  22 Mar 02
 * @version   $Revision: 1$ $Date: 03/22/02 12:47:14 PM$  
 * @since     Niagara 3.0 basicdriver 1.0                                
 */
public class BBasicPollScheduler
  extends BPollScheduler
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBasicPollScheduler.class);

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Poll the specified BIPollable object IF the parent BBasicNetwork is
   * not out-of-service.  Assumes the given
   * BIPollable object is a BIBasicPollable.
   *
   * @param p Object implementing the BIPollable interface 
   *    that should be cast to a BIBasicPollable and polled. 
   */
  public void doPoll(BIPollable p)
    throws Exception
  {
    boolean shouldPoll = true;
    try
    {
      BBasicNetwork net = (BBasicNetwork)getParent();
      shouldPoll = (!net.isDisabled()) && (!net.isDown()) && (!net.isFault());  // FIXX - should this be the case??
    }
    catch (Exception e)
    {
      shouldPoll = true;
    }
    
    if (!shouldPoll) return;
    
    BIBasicPollable dev = (BIBasicPollable)p;
    try { if (((BBasicNetwork)getParent()).getLog().isTraceOn()) ((BBasicNetwork)getParent()).getLog().trace("Poll <" + p + ">"); } catch(Exception e) { }
    try { dev.poll(); }
    catch ( NotRunningException e)
    {
      unsubscribe(dev);
    }
  }
}
