/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.serial;

import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.basicdriver.BBasicNetwork;

/**
 * BSerialNetwork is the base container for Serial Devices.  It extends BBasicNetwork
 * to support serial communication on a single configurable serial port.
 *
 * @author    Scott Hoye
 * @creation  22 Mar 02
 * @version   $Revision: 1$ $Date: 03/22/02 12:47:14 PM$
 * @since     Niagara 3.0 basicdriver 1.0
 */
public abstract class BSerialNetwork
  extends BBasicNetwork
  implements BISerialHelperParent
{
  /*-

  class BSerialNetwork
  {
    properties
    {
      interMessageDelay: BRelTime
        -- Specifies the minimum amount of time to wait after a response message is
        -- received before sending the next request message.
        default {[ BRelTime.make(0) ]}
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND) ]}
        
      serialPortConfig: BSerialHelper
        -- Contains the serial port properties
        default {[ new BSerialHelper() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.basicdriver.serial.BSerialNetwork(3042992115)1.0$ @*/
/* Generated Wed Feb 23 17:11:35 EST 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "interMessageDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>interMessageDelay</code> property.
   * Specifies the minimum amount of time to wait after
   * a response message is received before sending the next request message.
   * @see com.tridium.basicdriver.serial.BSerialNetwork#getInterMessageDelay
   * @see com.tridium.basicdriver.serial.BSerialNetwork#setInterMessageDelay
   */
  public static final Property interMessageDelay = newProperty(0, BRelTime.make(0),BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND) );
  
  /**
   * Get the <code>interMessageDelay</code> property.
   * @see com.tridium.basicdriver.serial.BSerialNetwork#interMessageDelay
   */
  public BRelTime getInterMessageDelay() { return (BRelTime)get(interMessageDelay); }
  
  /**
   * Set the <code>interMessageDelay</code> property.
   * @see com.tridium.basicdriver.serial.BSerialNetwork#interMessageDelay
   */
  public void setInterMessageDelay(BRelTime v) { set(interMessageDelay,v,null); }

////////////////////////////////////////////////////////////////
// Property "serialPortConfig"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>serialPortConfig</code> property.
   * Contains the serial port properties
   * @see com.tridium.basicdriver.serial.BSerialNetwork#getSerialPortConfig
   * @see com.tridium.basicdriver.serial.BSerialNetwork#setSerialPortConfig
   */
  public static final Property serialPortConfig = newProperty(0, new BSerialHelper(),null);
  
  /**
   * Get the <code>serialPortConfig</code> property.
   * @see com.tridium.basicdriver.serial.BSerialNetwork#serialPortConfig
   */
  public BSerialHelper getSerialPortConfig() { return (BSerialHelper)get(serialPortConfig); }
  
  /**
   * Set the <code>serialPortConfig</code> property.
   * @see com.tridium.basicdriver.serial.BSerialNetwork#serialPortConfig
   */
  public void setSerialPortConfig(BSerialHelper v) { set(serialPortConfig,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSerialNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor.
   */
  public BSerialNetwork()
  {
    super();
  }

  /**
   * Initializes the serial helper and serial log, and builds the Serial 
   * Communication Handler (SerialComm).
   */
  public void serviceStarted()
    throws Exception
  {
    // Set up the name subscriber
    subscriber = new NameSubscriber(this);
    subscriber.subscribe((BComponent)getParent());
    subscriber.subscribe(getSerialPortConfig());
    
    getSerialPortConfig().setSerialHelperParent(this);

    if (log == null)
      log = getLog();

    synchronized (log)
    {
      log = getLog();
    }

    super.serviceStarted();
  }
  
  
  /**
   * Stop the serial network.  This stops the SerialComm.
   */
  public void serviceStopped()
    throws Exception
  {
    super.serviceStopped();
    
    // Clear the name subscriber.
    subscriber.unsubscribeAll();
    subscriber = null;
  }
  
  /**
   * This method starts the Communication handler
   * (Comm) if the network is not out-of-service
   * and the current Comm is not null.
   */
  public void startComm()
    throws Exception
  {
    try
    {
      super.startComm();
      serialInitError = null;
    }
    catch (Exception e)
    {
      serialInitError = "Could not enable serial communication (" + e + ")";
      throw e;
    }
    finally
    {
      String error = checkSerialConfig();
      if (error == null) configOk();
      else configFail(error);
    }
  }
  
  /**
   * This method checks to see if there was a problem during the serial
   * network communication initialization (i.e. opening the serial port), and returns
   * a String description of the problem, if a problem was found.  Returns
   * null if there was no problem.  Callers should use this returned String
   * description to set the network in configuration fault (configFail()).
   * On returning null, callers should set the network out of configuration 
   * fault (configOk()).
   * Subclasses can override if needed (and call this super method) to insert
   * their own conditions for network failure.
   */
  protected String checkSerialConfig()
  {
    if (getSerialPortConfig().getPortName().equals(BSerialHelper.noPort))
      return "No port selected for serial communication.";
    return serialInitError;
  }

  /**
   * Returns the log currently used by this
   * serial network.  
   */
  public final Log getLog()
  {
    String serialLogName = (getName() + "_" + getSerialPortConfig().getPortName());
    if (!SlotPath.isValidName(serialLogName))
      serialLogName = SlotPath.escape(serialLogName);
    return Log.getLog(serialLogName);
  }

  public final String getLoggerName()
  {
    String serialLogName = (getType().getTypeName() + "_" + getSerialPortConfig().getPortName());
    if (!SlotPath.isValidName(serialLogName))
      serialLogName = SlotPath.escape(serialLogName);
    return serialLogName;
  }
  
  /**
   * Called when the network's name is changed to update the log
   */
  private void updateLog() 
  {
    String serialLogName = getName() + "_" + getSerialPortConfig().getPortName();
    if (!SlotPath.isValidName(serialLogName))
      serialLogName = SlotPath.escape(serialLogName);
    Log newLog = Log.getLog(serialLogName);

    if (log == null)
      log = getLog();

    synchronized(log)
    {
      if (log != null)
      {
        newLog.setSeverity(log.getSeverity());
        if (!(newLog.getLogName().equals(log.getLogName())))
          Log.deleteLog(log.getLogName());
      }
      log = newLog;
    }
  }
  
  /**
   * This method is called by BSerialHelper when the port name has changed
   * to indicate that a reinitialization of the serial port is 
   * required (i.e. close the old port, and 
   * and then call BSerialHelper.open() to open the new port).
   */
  public final void reopenPort()
  {
    try
    {
      String newPort = getSerialPortConfig().getPortName();
      
      if (newPort.equals(BSerialHelper.noPort))
      {  // 'none' is selected, so stop the network and don't restart
        configFail("No port selected for serial communication.");
        stopComm();
        return;
      }
      restartSerialNetwork();
    }
    catch (Exception e)
    {
      getLog().error("BSerialNetwork caught exception in reopenPort(): ", e);
    }
  }

  /**
   * Restarts the serial communication network.  This method
   * gets called when the serial port gets changed.
   */
  private void restartSerialNetwork()
    throws Exception
  {
    if ((!isDisabled()) && (!isDown()) && (!isFatalFault()))
    {
      if (log.isTraceOn()) log.trace(getName() + " *** Restarting serial comm ***");
      stopComm();
      startComm();
    }
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private Log log = null; // FIXX - what access should these have??
  private Subscriber subscriber;
  private String serialInitError = null;
  
////////////////////////////////////////////////////////////////
// Inner class: NameSubscriber
////////////////////////////////////////////////////////////////

  /**
   * NameSubscriber handles updating the network's log
   * when the network's name is changed.
   */
  private class NameSubscriber
    extends Subscriber
  {
    public NameSubscriber(BSerialNetwork net)
    {
      this.net = net;
    }

    public void event(BComponentEvent event)
    {
      if (event.getId() == BComponentEvent.PROPERTY_RENAMED)
      {
        if (event.getSlot().equals(net.getPropertyInParent()))
          net.updateLog();
      }
      else if (event.getId() == BComponentEvent.PROPERTY_CHANGED)
      {
        if (event.getSlot().equals(BSerialHelper.portName))
          net.updateLog();
      }
    }

    private BSerialNetwork net;
  }

////////////////////////////////////////////////////////////////
// Old
////////////////////////////////////////////////////////////////

  protected final void serialServiceStarted() throws Exception {}
  protected final void serialServiceStopped() throws Exception {}
  protected final void serialNetworkStarted() {}
  protected final void serialNetworkStopped() {}
  protected final void serialNetworkChanged(Property prop, Context context) {}

}
