/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.basicdriver.point;

import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.util.BBasicPollGroup;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.basicdriver.util.BasicWriteAsyncRequest;

/**
 * BasicDriver implementation of BProxyExt
 *
 * @author    Lenard Perkins
 * @creation  24 Feb 05
 * @version   $Revision: 1$ $Date: 2/22/2005 02:43:49 PM$
 * @since     Niagara 3.0
 */
public abstract class BBasicProxyExt
  extends BProxyExt
{
/*-
class BBasicProxyExt
{
}
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.basicdriver.point.BBasicProxyExt(2931732567)1.0$ @*/
/* Generated Mon Jun 06 09:42:50 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBasicProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * This method may optionally be overridden by a subclass is the
   * subclass is a member of a group of proxy extensions whose values
   * are retrieved by the same poll message. This allows the polling
   * of those proxies to be coalesced into a single poll.
   *
   * Proxy extensions that belong to the same Poll Group should
   * return the equivalent poll group code from this method.
   *
   * In other words, if two proxy extensions are polled by one poll group
   * then the Objects returned by either of the proxy extension should
   * equal each other when passed to each other's .equals methods.
   */
  public Object getPollGroupCode()
  {
    return null;
  }

  /**
   * If the getPollGroupCode() method is overridden then this method
   * should also be overridden so that this class can know which
   * Poll Group should be used to poll this proxy extension.
   */

  public Type getPollGroupType()
  {
    return null;
  }
  /**
   * This callback is made when the point enters a subscribed
   * state based on the current status and tuning.  The driver
   * should register for changes or begin polling.  Any IO should
   * be done asynchronously on another thread - never block the
   * calling thread.  The result of reads should be to call the
   * readOk() or readFail() method.
   */
  public void readSubscribed(Context cx)
    throws Exception
  {
    // Descendants aren't necessarily pollable, let's check.
    if (this instanceof BIBasicPollable)
    {
      // Registers to the BasicDriver's poll scheduler
      BBasicNetwork network = (BBasicNetwork)getNetwork();
      if (network != null)
      {
        network.getPollScheduler().subscribe((BIBasicPollable)this);
        if (network.getLog().isTraceOn())
          network.getLog().trace("Sub <" + this + ">");
      }
    }
    // If this proxy extension does not implement a poll method, then
    // Let's see if it is a member of a PollGroup encapsulating multiple
    // Proxy extensions that are polled by the same poll message.
    else if (this.getPollGroupCode()!=null)
    { // Gets the poll group for this proxy
      BBasicPollGroup pg = BBasicPollGroup.getPollGroup( this );
      pg.readSubscribed( this ); // Subscribes this proxy to the BPollGroup for polling
    }
  }
  /**
   * This callback is made when the point exits the subscribed
   * state based on the current status and tuning.  The driver
   * should unregister for changes of cease polling.  Any IO should
   * be done asynchronously on another thread - never block the
   * calling thread.
   */
  public void readUnsubscribed(Context cx)
    throws Exception
  {
    if (this instanceof BIBasicPollable) // Descendants aren't necessarily pollable, let's check.
    {
      // Unregisters from the BasicDriver's poll scheduler
      BBasicNetwork network = (BBasicNetwork)getNetwork();

      if (network != null)
      {
        network.getPollScheduler().unsubscribe((BIBasicPollable)this);
        if (network.getLog().isTraceOn())
          network.getLog().trace("Unsub <" + this + ">");
      }
    }
    // If this proxy extension does not implement a poll method, then
    // Let's see if it is a member of a PollGroup encapsulating multiple
    // Proxy extensions that are polled by the same poll message.
    else if (this.getPollGroupCode()!=null)
    { // Gets the poll group for this proxy
      BBasicPollGroup pg = BBasicPollGroup.getPollGroup( this );
      pg.readUnsubscribed( this ); // Unsubscribes this proxy from the BPollGroup for polling
    }
  }

  public void started()
    throws Exception
  {
    if (getPollGroupCode()!=null) // If this proxy is to be polled in a coalesceing group
    {                             // Then this registers the proxy to its BPollGroup
      BBasicPollGroup.getPollGroup(this).registerProxy(this);
    }
    super.started();
  }

  public void stopped()
    throws Exception
  {
    readUnsubscribed(null);
    if (getPollGroupCode()!=null) // If this proxy was being polled in a coalesceing group
    {                             // Then this unregisters the proxy from the BPollGroup
      BBasicPollGroup.getPollGroup(this).unregisterProxy(this);
    }
    super.stopped();
  }  
  
  /**
   * Provides a reasonable default implementation. If under a writable point then
   * this returns BReadWriteMode.readWrite. Otherwise this proxy is under a control
   * point that is not a Writable so this method returns BReadWriteMode.readOnly.
   */
  public BReadWriteMode getMode()
  {
    return getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
  }
  
  /**
   * This is an override point to allow descendant classes to override
   * the default behavior of the BBasicProxyExt.writeFail method.
   * @return true.
   */
  protected boolean logWriteFail()
  {//
    return true;
  }
  
  /**
   * This method is called when a write to the device
   * fails for any reason. 
   */
  @SuppressWarnings("deprecation")
  public void writeFail(String cause)
  {
    if (logWriteFail())
    {
      getNetwork().getLog().error(getSlotPath().toDisplayString()+' '+getParentPoint().getOutStatusValue()+" to "+getWriteValue()+' '+cause);
    }
    super.writeFail(cause);
  }

  /**
   * This callback is made when a write is desired based on the
   * current status and tuning. This method posts a BasicWriteAsyncRequest
   * to the network's write worker thread. The BasicWriteAsyncRequest
   * then calls this object's doWrite method from the write worker's
   * thread, where it is safe to perform foreign communication.
   *
   * @return true if a write is now pending
   */
  public boolean write(Context cx)
    throws Exception
  {
    if (getMode()!=BReadWriteMode.readonly)
    {
      BStatusValue out = getWriteValue();
      if(out.getStatus().isNull())
        return false;

      BBasicNetwork network = (BBasicNetwork)getNetwork();
      if (network.getLog().isTraceOn()) network.getLog().trace("Write <"+this+"> " + out);

      // Post writes on the coalescing request queue!
      try
      {
        network.postWrite(new BasicWriteAsyncRequest(this, out));
      }
      catch (Exception e)
      { // Fix issue 7599
        writeFail(lex.getText("postWriteFail")+": "+e);
        network.getLog().error("Could not post write for "+getParent().getName(), e);        
      }
    }
    
    // Always return false - fixes issue 7843 (no writePending flags set)
    return false;
  }

  /**
   * This callback from asynchronous thread to send a write to the device.
   * Can be implemented by subclasses!
   *
   * @param BStatusValue out is the value to be sent to the foreign hardware
   */
  public void doWrite(BStatusValue out){}
  
  private static Lexicon lex = Lexicon.make(BBasicProxyExt.class);
}