/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
 
package com.tridium.basicdriver.comm;

import com.tridium.basicdriver.message.Message;

/**
 * A CommTransaction contains the data needed to handle 
 * a message request/response transaction.
 *
 * @author    Scott Hoye (taken from Robert Adams' LonTransaction)
 * @creation  01 Apr 02
 * @version   $Revision: 1$ $Date: 04/01/02 12:47:14 PM$  
 * @since     Niagara 3.0 basicdriver 1.0
 */
public class CommTransaction
{

////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////
  
 /**
  * Constructor - initializes the integer transaction identifier
  * associated with this transaction.
  */  
  public CommTransaction(int transactionId)
  { 
    this.transactionId = transactionId;
  }

////////////////////////////////////////////////////////////
//  Access methods  
////////////////////////////////////////////////////////////
  
 /**  
  * Stores the response message for this transaction 
  */
  public void setResponseMessage(Message msg)  { responseMessage = msg; }
  
 /** 
  * Gets the response message for this transaction 
  */
  public Message getResponseMessage() { return responseMessage; }

  /** 
   * Stores the request message for this transaction
   */
  public void setRequestMessage(Message a) {requestMessage = a; }
  
  /** 
   * Gets the request message for this transaction
   */
  public Message getRequestMessage() { return requestMessage;  }
  
  /** 
   * Stores the integer transaction identifier
   * associated with this transaction.
   */
  public void setCommTransactionId(int transactionId) { this.transactionId = transactionId; }
  
  /** 
   * Gets the integer transaction identifier
   * associated with this transaction.
   */
  public int getCommTransactionId() { return transactionId; }

  /** 
   * Stores whether this transaction is currently being used.  
   * True if used, false if not.
   */
  public void setUsed(boolean u) { used = u; }
  
  /** 
   * Returns whether this transaction is currently being used.  
   * True if used, false if not.
   */
  public boolean isUsed() { return ( used);}

  /** 
   * Stores whether this transaction is complete.  
   * True if complete, false if not.
   */
  public void setComplete(boolean c)  {complete = c; }

  /** 
   * Returns whether this transaction is complete.  
   * True if complete, false if not.
   */
  public boolean isComplete()  { return complete; }

////////////////////////////////////////////////////////////
//  Attributes of CommTransaction
////////////////////////////////////////////////////////////
  private Message requestMessage = null;
  private Message responseMessage = null;
  private int transactionId = -1; // Default is integer -1.
  private boolean used = false;
  private boolean complete = false;    
}
