/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.text;

import java.io.*;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.*;
import javax.baja.sys.*;
import javax.baja.xml.*;
import javax.baja.ui.*;
import javax.baja.ui.event.*;
import javax.baja.ui.text.commands.*;

/**
 * The BKeyBindings stores a mapping between TextCommands 
 * and BAccelerator keys.
 *
 * @author    Brian Frank
 * @creation  7 Jul 01
 * @version   $Revision: 17$ $Date: 3/28/05 10:32:33 AM EST$
 * @since     Baja 1.0
 */
public class BKeyBindings
  extends BComponent
{        
  
  /*-
  
  class BKeyBindings
  {
    properties
    {
      moveUp: BAccelerator
        default {[ BAccelerator.make("Up") ]}
      moveDown: BAccelerator
        default {[ BAccelerator.make("Down") ]}
      moveLeft: BAccelerator
        default {[ BAccelerator.make("Left") ]}
      moveRight: BAccelerator
        default {[ BAccelerator.make("Right") ]}
      pageUp: BAccelerator
        default {[ BAccelerator.make("PageUp") ]}
      pageDown: BAccelerator
        default {[ BAccelerator.make("PageDown") ]}
      lineStart: BAccelerator
        default {[ BAccelerator.make("Home") ]}
      lineEnd: BAccelerator
        default {[ BAccelerator.make("End") ]}
      documentStart: BAccelerator
        default {[ BAccelerator.make("Ctrl+Home") ]}
      documentEnd: BAccelerator
        default {[ BAccelerator.make("Ctrl+End") ]}
      wordLeft: BAccelerator
        default {[ BAccelerator.make("Ctrl+Left") ]}
      wordRight: BAccelerator
        default {[ BAccelerator.make("Ctrl+Right") ]}
        
      cut: BAccelerator
        default {[ BAccelerator.make("Ctrl+X") ]}
      copy: BAccelerator
        default {[ BAccelerator.make("Ctrl+C") ]}
      paste: BAccelerator
        default {[ BAccelerator.make("Ctrl+V") ]}
      cut2: BAccelerator
        default {[ BAccelerator.make("Shift+Delete") ]}
      copy2: BAccelerator
        default {[ BAccelerator.make("Ctrl+Insert") ]}
      paste2: BAccelerator
        default {[ BAccelerator.make("Shift+Insert") ]}
        
      undo: BAccelerator
        default {[ BAccelerator.make("Ctrl+Z") ]}
      redo: BAccelerator
        default {[ BAccelerator.make("Ctrl+Alt+Z") ]}
        
      delete: BAccelerator
        default {[ BAccelerator.make("Delete") ]}
      backspace: BAccelerator
        default {[ BAccelerator.make("Backspace") ]}
      cutLine: BAccelerator
        default {[ BAccelerator.make("Ctrl+Y") ]}
      deleteWord: BAccelerator
        default {[ BAccelerator.make("Ctrl+Delete") ]}
        
      tabForward: BAccelerator
        default {[ BAccelerator.make("Tab") ]}
      tabBack: BAccelerator
        default {[ BAccelerator.make("Shift+Tab") ]}
      toggleSlashSlash: BAccelerator
        default {[ BAccelerator.make("Ctrl+/") ]}
      wordWrap: BAccelerator
        default {[ BAccelerator.make("Ctrl+W") ]}
        
      goTo: BAccelerator
        default {[ BAccelerator.make("Ctrl+G") ]}
      find: BAccelerator
        default {[ BAccelerator.make("F5") ]}
      findNext: BAccelerator
        default {[ BAccelerator.make("Ctrl+F") ]}
      findPrev: BAccelerator
        default {[ BAccelerator.make("Ctrl+Shift+F") ]}
      replace: BAccelerator
        default {[ BAccelerator.make("F6") ]}
        
      reloadMacros: BAccelerator
        default {[ BAccelerator.make("Ctrl+M") ]}
      selectAll: BAccelerator
        default {[ BAccelerator.make("Ctrl+A") ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.text.BKeyBindings(2349364704)1.0$ @*/
/* Generated Wed Jan 14 09:35:48 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "moveUp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>moveUp</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getMoveUp
   * @see javax.baja.ui.text.BKeyBindings#setMoveUp
   */
  public static final Property moveUp = newProperty(0, BAccelerator.make("Up"),null);
  
  /**
   * Get the <code>moveUp</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveUp
   */
  public BAccelerator getMoveUp() { return (BAccelerator)get(moveUp); }
  
  /**
   * Set the <code>moveUp</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveUp
   */
  public void setMoveUp(BAccelerator v) { set(moveUp,v,null); }

////////////////////////////////////////////////////////////////
// Property "moveDown"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>moveDown</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getMoveDown
   * @see javax.baja.ui.text.BKeyBindings#setMoveDown
   */
  public static final Property moveDown = newProperty(0, BAccelerator.make("Down"),null);
  
  /**
   * Get the <code>moveDown</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveDown
   */
  public BAccelerator getMoveDown() { return (BAccelerator)get(moveDown); }
  
  /**
   * Set the <code>moveDown</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveDown
   */
  public void setMoveDown(BAccelerator v) { set(moveDown,v,null); }

////////////////////////////////////////////////////////////////
// Property "moveLeft"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>moveLeft</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getMoveLeft
   * @see javax.baja.ui.text.BKeyBindings#setMoveLeft
   */
  public static final Property moveLeft = newProperty(0, BAccelerator.make("Left"),null);
  
  /**
   * Get the <code>moveLeft</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveLeft
   */
  public BAccelerator getMoveLeft() { return (BAccelerator)get(moveLeft); }
  
  /**
   * Set the <code>moveLeft</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveLeft
   */
  public void setMoveLeft(BAccelerator v) { set(moveLeft,v,null); }

////////////////////////////////////////////////////////////////
// Property "moveRight"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>moveRight</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getMoveRight
   * @see javax.baja.ui.text.BKeyBindings#setMoveRight
   */
  public static final Property moveRight = newProperty(0, BAccelerator.make("Right"),null);
  
  /**
   * Get the <code>moveRight</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveRight
   */
  public BAccelerator getMoveRight() { return (BAccelerator)get(moveRight); }
  
  /**
   * Set the <code>moveRight</code> property.
   * @see javax.baja.ui.text.BKeyBindings#moveRight
   */
  public void setMoveRight(BAccelerator v) { set(moveRight,v,null); }

////////////////////////////////////////////////////////////////
// Property "pageUp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pageUp</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getPageUp
   * @see javax.baja.ui.text.BKeyBindings#setPageUp
   */
  public static final Property pageUp = newProperty(0, BAccelerator.make("PageUp"),null);
  
  /**
   * Get the <code>pageUp</code> property.
   * @see javax.baja.ui.text.BKeyBindings#pageUp
   */
  public BAccelerator getPageUp() { return (BAccelerator)get(pageUp); }
  
  /**
   * Set the <code>pageUp</code> property.
   * @see javax.baja.ui.text.BKeyBindings#pageUp
   */
  public void setPageUp(BAccelerator v) { set(pageUp,v,null); }

////////////////////////////////////////////////////////////////
// Property "pageDown"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pageDown</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getPageDown
   * @see javax.baja.ui.text.BKeyBindings#setPageDown
   */
  public static final Property pageDown = newProperty(0, BAccelerator.make("PageDown"),null);
  
  /**
   * Get the <code>pageDown</code> property.
   * @see javax.baja.ui.text.BKeyBindings#pageDown
   */
  public BAccelerator getPageDown() { return (BAccelerator)get(pageDown); }
  
  /**
   * Set the <code>pageDown</code> property.
   * @see javax.baja.ui.text.BKeyBindings#pageDown
   */
  public void setPageDown(BAccelerator v) { set(pageDown,v,null); }

////////////////////////////////////////////////////////////////
// Property "lineStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lineStart</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getLineStart
   * @see javax.baja.ui.text.BKeyBindings#setLineStart
   */
  public static final Property lineStart = newProperty(0, BAccelerator.make("Home"),null);
  
  /**
   * Get the <code>lineStart</code> property.
   * @see javax.baja.ui.text.BKeyBindings#lineStart
   */
  public BAccelerator getLineStart() { return (BAccelerator)get(lineStart); }
  
  /**
   * Set the <code>lineStart</code> property.
   * @see javax.baja.ui.text.BKeyBindings#lineStart
   */
  public void setLineStart(BAccelerator v) { set(lineStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "lineEnd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lineEnd</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getLineEnd
   * @see javax.baja.ui.text.BKeyBindings#setLineEnd
   */
  public static final Property lineEnd = newProperty(0, BAccelerator.make("End"),null);
  
  /**
   * Get the <code>lineEnd</code> property.
   * @see javax.baja.ui.text.BKeyBindings#lineEnd
   */
  public BAccelerator getLineEnd() { return (BAccelerator)get(lineEnd); }
  
  /**
   * Set the <code>lineEnd</code> property.
   * @see javax.baja.ui.text.BKeyBindings#lineEnd
   */
  public void setLineEnd(BAccelerator v) { set(lineEnd,v,null); }

////////////////////////////////////////////////////////////////
// Property "documentStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>documentStart</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getDocumentStart
   * @see javax.baja.ui.text.BKeyBindings#setDocumentStart
   */
  public static final Property documentStart = newProperty(0, BAccelerator.make("Ctrl+Home"),null);
  
  /**
   * Get the <code>documentStart</code> property.
   * @see javax.baja.ui.text.BKeyBindings#documentStart
   */
  public BAccelerator getDocumentStart() { return (BAccelerator)get(documentStart); }
  
  /**
   * Set the <code>documentStart</code> property.
   * @see javax.baja.ui.text.BKeyBindings#documentStart
   */
  public void setDocumentStart(BAccelerator v) { set(documentStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "documentEnd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>documentEnd</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getDocumentEnd
   * @see javax.baja.ui.text.BKeyBindings#setDocumentEnd
   */
  public static final Property documentEnd = newProperty(0, BAccelerator.make("Ctrl+End"),null);
  
  /**
   * Get the <code>documentEnd</code> property.
   * @see javax.baja.ui.text.BKeyBindings#documentEnd
   */
  public BAccelerator getDocumentEnd() { return (BAccelerator)get(documentEnd); }
  
  /**
   * Set the <code>documentEnd</code> property.
   * @see javax.baja.ui.text.BKeyBindings#documentEnd
   */
  public void setDocumentEnd(BAccelerator v) { set(documentEnd,v,null); }

////////////////////////////////////////////////////////////////
// Property "wordLeft"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>wordLeft</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getWordLeft
   * @see javax.baja.ui.text.BKeyBindings#setWordLeft
   */
  public static final Property wordLeft = newProperty(0, BAccelerator.make("Ctrl+Left"),null);
  
  /**
   * Get the <code>wordLeft</code> property.
   * @see javax.baja.ui.text.BKeyBindings#wordLeft
   */
  public BAccelerator getWordLeft() { return (BAccelerator)get(wordLeft); }
  
  /**
   * Set the <code>wordLeft</code> property.
   * @see javax.baja.ui.text.BKeyBindings#wordLeft
   */
  public void setWordLeft(BAccelerator v) { set(wordLeft,v,null); }

////////////////////////////////////////////////////////////////
// Property "wordRight"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>wordRight</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getWordRight
   * @see javax.baja.ui.text.BKeyBindings#setWordRight
   */
  public static final Property wordRight = newProperty(0, BAccelerator.make("Ctrl+Right"),null);
  
  /**
   * Get the <code>wordRight</code> property.
   * @see javax.baja.ui.text.BKeyBindings#wordRight
   */
  public BAccelerator getWordRight() { return (BAccelerator)get(wordRight); }
  
  /**
   * Set the <code>wordRight</code> property.
   * @see javax.baja.ui.text.BKeyBindings#wordRight
   */
  public void setWordRight(BAccelerator v) { set(wordRight,v,null); }

////////////////////////////////////////////////////////////////
// Property "cut"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cut</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getCut
   * @see javax.baja.ui.text.BKeyBindings#setCut
   */
  public static final Property cut = newProperty(0, BAccelerator.make("Ctrl+X"),null);
  
  /**
   * Get the <code>cut</code> property.
   * @see javax.baja.ui.text.BKeyBindings#cut
   */
  public BAccelerator getCut() { return (BAccelerator)get(cut); }
  
  /**
   * Set the <code>cut</code> property.
   * @see javax.baja.ui.text.BKeyBindings#cut
   */
  public void setCut(BAccelerator v) { set(cut,v,null); }

////////////////////////////////////////////////////////////////
// Property "copy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>copy</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getCopy
   * @see javax.baja.ui.text.BKeyBindings#setCopy
   */
  public static final Property copy = newProperty(0, BAccelerator.make("Ctrl+C"),null);
  
  /**
   * Get the <code>copy</code> property.
   * @see javax.baja.ui.text.BKeyBindings#copy
   */
  public BAccelerator getCopy() { return (BAccelerator)get(copy); }
  
  /**
   * Set the <code>copy</code> property.
   * @see javax.baja.ui.text.BKeyBindings#copy
   */
  public void setCopy(BAccelerator v) { set(copy,v,null); }

////////////////////////////////////////////////////////////////
// Property "paste"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>paste</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getPaste
   * @see javax.baja.ui.text.BKeyBindings#setPaste
   */
  public static final Property paste = newProperty(0, BAccelerator.make("Ctrl+V"),null);
  
  /**
   * Get the <code>paste</code> property.
   * @see javax.baja.ui.text.BKeyBindings#paste
   */
  public BAccelerator getPaste() { return (BAccelerator)get(paste); }
  
  /**
   * Set the <code>paste</code> property.
   * @see javax.baja.ui.text.BKeyBindings#paste
   */
  public void setPaste(BAccelerator v) { set(paste,v,null); }

////////////////////////////////////////////////////////////////
// Property "cut2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cut2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getCut2
   * @see javax.baja.ui.text.BKeyBindings#setCut2
   */
  public static final Property cut2 = newProperty(0, BAccelerator.make("Shift+Delete"),null);
  
  /**
   * Get the <code>cut2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#cut2
   */
  public BAccelerator getCut2() { return (BAccelerator)get(cut2); }
  
  /**
   * Set the <code>cut2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#cut2
   */
  public void setCut2(BAccelerator v) { set(cut2,v,null); }

////////////////////////////////////////////////////////////////
// Property "copy2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>copy2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getCopy2
   * @see javax.baja.ui.text.BKeyBindings#setCopy2
   */
  public static final Property copy2 = newProperty(0, BAccelerator.make("Ctrl+Insert"),null);
  
  /**
   * Get the <code>copy2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#copy2
   */
  public BAccelerator getCopy2() { return (BAccelerator)get(copy2); }
  
  /**
   * Set the <code>copy2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#copy2
   */
  public void setCopy2(BAccelerator v) { set(copy2,v,null); }

////////////////////////////////////////////////////////////////
// Property "paste2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>paste2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getPaste2
   * @see javax.baja.ui.text.BKeyBindings#setPaste2
   */
  public static final Property paste2 = newProperty(0, BAccelerator.make("Shift+Insert"),null);
  
  /**
   * Get the <code>paste2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#paste2
   */
  public BAccelerator getPaste2() { return (BAccelerator)get(paste2); }
  
  /**
   * Set the <code>paste2</code> property.
   * @see javax.baja.ui.text.BKeyBindings#paste2
   */
  public void setPaste2(BAccelerator v) { set(paste2,v,null); }

////////////////////////////////////////////////////////////////
// Property "undo"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>undo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getUndo
   * @see javax.baja.ui.text.BKeyBindings#setUndo
   */
  public static final Property undo = newProperty(0, BAccelerator.make("Ctrl+Z"),null);
  
  /**
   * Get the <code>undo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#undo
   */
  public BAccelerator getUndo() { return (BAccelerator)get(undo); }
  
  /**
   * Set the <code>undo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#undo
   */
  public void setUndo(BAccelerator v) { set(undo,v,null); }

////////////////////////////////////////////////////////////////
// Property "redo"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>redo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getRedo
   * @see javax.baja.ui.text.BKeyBindings#setRedo
   */
  public static final Property redo = newProperty(0, BAccelerator.make("Ctrl+Alt+Z"),null);
  
  /**
   * Get the <code>redo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#redo
   */
  public BAccelerator getRedo() { return (BAccelerator)get(redo); }
  
  /**
   * Set the <code>redo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#redo
   */
  public void setRedo(BAccelerator v) { set(redo,v,null); }

////////////////////////////////////////////////////////////////
// Property "delete"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>delete</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getDelete
   * @see javax.baja.ui.text.BKeyBindings#setDelete
   */
  public static final Property delete = newProperty(0, BAccelerator.make("Delete"),null);
  
  /**
   * Get the <code>delete</code> property.
   * @see javax.baja.ui.text.BKeyBindings#delete
   */
  public BAccelerator getDelete() { return (BAccelerator)get(delete); }
  
  /**
   * Set the <code>delete</code> property.
   * @see javax.baja.ui.text.BKeyBindings#delete
   */
  public void setDelete(BAccelerator v) { set(delete,v,null); }

////////////////////////////////////////////////////////////////
// Property "backspace"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>backspace</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getBackspace
   * @see javax.baja.ui.text.BKeyBindings#setBackspace
   */
  public static final Property backspace = newProperty(0, BAccelerator.make("Backspace"),null);
  
  /**
   * Get the <code>backspace</code> property.
   * @see javax.baja.ui.text.BKeyBindings#backspace
   */
  public BAccelerator getBackspace() { return (BAccelerator)get(backspace); }
  
  /**
   * Set the <code>backspace</code> property.
   * @see javax.baja.ui.text.BKeyBindings#backspace
   */
  public void setBackspace(BAccelerator v) { set(backspace,v,null); }

////////////////////////////////////////////////////////////////
// Property "cutLine"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cutLine</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getCutLine
   * @see javax.baja.ui.text.BKeyBindings#setCutLine
   */
  public static final Property cutLine = newProperty(0, BAccelerator.make("Ctrl+Y"),null);
  
  /**
   * Get the <code>cutLine</code> property.
   * @see javax.baja.ui.text.BKeyBindings#cutLine
   */
  public BAccelerator getCutLine() { return (BAccelerator)get(cutLine); }
  
  /**
   * Set the <code>cutLine</code> property.
   * @see javax.baja.ui.text.BKeyBindings#cutLine
   */
  public void setCutLine(BAccelerator v) { set(cutLine,v,null); }

////////////////////////////////////////////////////////////////
// Property "deleteWord"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deleteWord</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getDeleteWord
   * @see javax.baja.ui.text.BKeyBindings#setDeleteWord
   */
  public static final Property deleteWord = newProperty(0, BAccelerator.make("Ctrl+Delete"),null);
  
  /**
   * Get the <code>deleteWord</code> property.
   * @see javax.baja.ui.text.BKeyBindings#deleteWord
   */
  public BAccelerator getDeleteWord() { return (BAccelerator)get(deleteWord); }
  
  /**
   * Set the <code>deleteWord</code> property.
   * @see javax.baja.ui.text.BKeyBindings#deleteWord
   */
  public void setDeleteWord(BAccelerator v) { set(deleteWord,v,null); }

////////////////////////////////////////////////////////////////
// Property "tabForward"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tabForward</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getTabForward
   * @see javax.baja.ui.text.BKeyBindings#setTabForward
   */
  public static final Property tabForward = newProperty(0, BAccelerator.make("Tab"),null);
  
  /**
   * Get the <code>tabForward</code> property.
   * @see javax.baja.ui.text.BKeyBindings#tabForward
   */
  public BAccelerator getTabForward() { return (BAccelerator)get(tabForward); }
  
  /**
   * Set the <code>tabForward</code> property.
   * @see javax.baja.ui.text.BKeyBindings#tabForward
   */
  public void setTabForward(BAccelerator v) { set(tabForward,v,null); }

////////////////////////////////////////////////////////////////
// Property "tabBack"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tabBack</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getTabBack
   * @see javax.baja.ui.text.BKeyBindings#setTabBack
   */
  public static final Property tabBack = newProperty(0, BAccelerator.make("Shift+Tab"),null);
  
  /**
   * Get the <code>tabBack</code> property.
   * @see javax.baja.ui.text.BKeyBindings#tabBack
   */
  public BAccelerator getTabBack() { return (BAccelerator)get(tabBack); }
  
  /**
   * Set the <code>tabBack</code> property.
   * @see javax.baja.ui.text.BKeyBindings#tabBack
   */
  public void setTabBack(BAccelerator v) { set(tabBack,v,null); }

////////////////////////////////////////////////////////////////
// Property "toggleSlashSlash"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>toggleSlashSlash</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getToggleSlashSlash
   * @see javax.baja.ui.text.BKeyBindings#setToggleSlashSlash
   */
  public static final Property toggleSlashSlash = newProperty(0, BAccelerator.make("Ctrl+/"),null);
  
  /**
   * Get the <code>toggleSlashSlash</code> property.
   * @see javax.baja.ui.text.BKeyBindings#toggleSlashSlash
   */
  public BAccelerator getToggleSlashSlash() { return (BAccelerator)get(toggleSlashSlash); }
  
  /**
   * Set the <code>toggleSlashSlash</code> property.
   * @see javax.baja.ui.text.BKeyBindings#toggleSlashSlash
   */
  public void setToggleSlashSlash(BAccelerator v) { set(toggleSlashSlash,v,null); }

////////////////////////////////////////////////////////////////
// Property "wordWrap"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>wordWrap</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getWordWrap
   * @see javax.baja.ui.text.BKeyBindings#setWordWrap
   */
  public static final Property wordWrap = newProperty(0, BAccelerator.make("Ctrl+W"),null);
  
  /**
   * Get the <code>wordWrap</code> property.
   * @see javax.baja.ui.text.BKeyBindings#wordWrap
   */
  public BAccelerator getWordWrap() { return (BAccelerator)get(wordWrap); }
  
  /**
   * Set the <code>wordWrap</code> property.
   * @see javax.baja.ui.text.BKeyBindings#wordWrap
   */
  public void setWordWrap(BAccelerator v) { set(wordWrap,v,null); }

////////////////////////////////////////////////////////////////
// Property "goTo"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>goTo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getGoTo
   * @see javax.baja.ui.text.BKeyBindings#setGoTo
   */
  public static final Property goTo = newProperty(0, BAccelerator.make("Ctrl+G"),null);
  
  /**
   * Get the <code>goTo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#goTo
   */
  public BAccelerator getGoTo() { return (BAccelerator)get(goTo); }
  
  /**
   * Set the <code>goTo</code> property.
   * @see javax.baja.ui.text.BKeyBindings#goTo
   */
  public void setGoTo(BAccelerator v) { set(goTo,v,null); }

////////////////////////////////////////////////////////////////
// Property "find"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>find</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getFind
   * @see javax.baja.ui.text.BKeyBindings#setFind
   */
  public static final Property find = newProperty(0, BAccelerator.make("F5"),null);
  
  /**
   * Get the <code>find</code> property.
   * @see javax.baja.ui.text.BKeyBindings#find
   */
  public BAccelerator getFind() { return (BAccelerator)get(find); }
  
  /**
   * Set the <code>find</code> property.
   * @see javax.baja.ui.text.BKeyBindings#find
   */
  public void setFind(BAccelerator v) { set(find,v,null); }

////////////////////////////////////////////////////////////////
// Property "findNext"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>findNext</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getFindNext
   * @see javax.baja.ui.text.BKeyBindings#setFindNext
   */
  public static final Property findNext = newProperty(0, BAccelerator.make("Ctrl+F"),null);
  
  /**
   * Get the <code>findNext</code> property.
   * @see javax.baja.ui.text.BKeyBindings#findNext
   */
  public BAccelerator getFindNext() { return (BAccelerator)get(findNext); }
  
  /**
   * Set the <code>findNext</code> property.
   * @see javax.baja.ui.text.BKeyBindings#findNext
   */
  public void setFindNext(BAccelerator v) { set(findNext,v,null); }

////////////////////////////////////////////////////////////////
// Property "findPrev"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>findPrev</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getFindPrev
   * @see javax.baja.ui.text.BKeyBindings#setFindPrev
   */
  public static final Property findPrev = newProperty(0, BAccelerator.make("Ctrl+Shift+F"),null);
  
  /**
   * Get the <code>findPrev</code> property.
   * @see javax.baja.ui.text.BKeyBindings#findPrev
   */
  public BAccelerator getFindPrev() { return (BAccelerator)get(findPrev); }
  
  /**
   * Set the <code>findPrev</code> property.
   * @see javax.baja.ui.text.BKeyBindings#findPrev
   */
  public void setFindPrev(BAccelerator v) { set(findPrev,v,null); }

////////////////////////////////////////////////////////////////
// Property "replace"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>replace</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getReplace
   * @see javax.baja.ui.text.BKeyBindings#setReplace
   */
  public static final Property replace = newProperty(0, BAccelerator.make("F6"),null);
  
  /**
   * Get the <code>replace</code> property.
   * @see javax.baja.ui.text.BKeyBindings#replace
   */
  public BAccelerator getReplace() { return (BAccelerator)get(replace); }
  
  /**
   * Set the <code>replace</code> property.
   * @see javax.baja.ui.text.BKeyBindings#replace
   */
  public void setReplace(BAccelerator v) { set(replace,v,null); }

////////////////////////////////////////////////////////////////
// Property "reloadMacros"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>reloadMacros</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getReloadMacros
   * @see javax.baja.ui.text.BKeyBindings#setReloadMacros
   */
  public static final Property reloadMacros = newProperty(0, BAccelerator.make("Ctrl+M"),null);
  
  /**
   * Get the <code>reloadMacros</code> property.
   * @see javax.baja.ui.text.BKeyBindings#reloadMacros
   */
  public BAccelerator getReloadMacros() { return (BAccelerator)get(reloadMacros); }
  
  /**
   * Set the <code>reloadMacros</code> property.
   * @see javax.baja.ui.text.BKeyBindings#reloadMacros
   */
  public void setReloadMacros(BAccelerator v) { set(reloadMacros,v,null); }

////////////////////////////////////////////////////////////////
// Property "selectAll"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selectAll</code> property.
   * @see javax.baja.ui.text.BKeyBindings#getSelectAll
   * @see javax.baja.ui.text.BKeyBindings#setSelectAll
   */
  public static final Property selectAll = newProperty(0, BAccelerator.make("Ctrl+A"),null);
  
  /**
   * Get the <code>selectAll</code> property.
   * @see javax.baja.ui.text.BKeyBindings#selectAll
   */
  public BAccelerator getSelectAll() { return (BAccelerator)get(selectAll); }
  
  /**
   * Set the <code>selectAll</code> property.
   * @see javax.baja.ui.text.BKeyBindings#selectAll
   */
  public void setSelectAll(BAccelerator v) { set(selectAll,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BKeyBindings.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Lookup
////////////////////////////////////////////////////////////////

  /**
   * Map an event to a Command, or return null if no key
   * binding for the specified BKeyEvent.
   */
  public Command eventToCommand(BTextEditor editor, BKeyEvent event)
  {
    if (table == null) updateTable();
    int keyCode = event.getKeyCode();
    int modifiers = event.getModifiers();
    
    // lookup the accelerator
    BAccelerator acc = BAccelerator.make(keyCode, modifiers);
    Property prop = table.get(acc);
    
    // map to a command if found
    if (prop != null)
      return editor.getCommandFactory().make(prop.getName());
    
    // try a macro
    Macro macro = macros.get(acc);
    if (macro != null)
      return macro.makeCommand(editor);
      
    // now we try to see if the event maps to a 
    // MoveCommand without the shift key
    if (event.isShiftDown())
    {
      acc = BAccelerator.make(keyCode, modifiers & ~BKeyEvent.SHIFT_MASK);
      prop = table.get(acc);
      if (prop != null)
      {
        Command command = editor.getCommandFactory().make(prop.getName());
        if (command instanceof MoveCommand)
        {
          MoveCommand moveCommand = (MoveCommand)command;
          moveCommand.setShiftDown(true);
          return moveCommand;
        }
      }
    }
    
    return null;
  }           
  
  /**
   * Populate cached lookup table.
   */
  void updateTable()
  {               
    table = new Hashtable<>();
    SlotCursor<Property> c = getProperties();
    while(c.next())
      table.put(c.get(), c.property());
  }                              

  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    updateTable();
  }

////////////////////////////////////////////////////////////////
// macros
////////////////////////////////////////////////////////////////

  private static Hashtable<BAccelerator, Macro> macros = new Hashtable<>();
  static { loadMacros(); }

  public static void loadMacros()
  {
    AccessController.doPrivileged(new LoadMacrosPrivilegedAction());
  }

  private static class LoadMacrosPrivilegedAction
    implements PrivilegedAction<Void>
  {
    @Override
    public Void run()
    {
      try
      {
        macros.clear();
        File file = new File(Sys.getNiagaraUserHome(), "etc/macros.xml");
        if (file.exists())
        {
          XElem elem = XParser.make(file).parse();
          XElem[] mcrs = elem.elems();
          for(int i=0; i<mcrs.length; ++i)
          {
            Macro m = new Macro(mcrs[i]);
            macros.put(m.acc, m);
          }
        }
      }
      catch(Exception e)
      {
        System.out.print("ERROR: Cannot initialize macros");
        e.printStackTrace();
      }

      return null;
    }
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("keyboardKey.png");
  

////////////////////////////////////////////////////////////////
// attribs
////////////////////////////////////////////////////////////////

  Hashtable<BValue, Property> table;

} 


