/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.text;

import javax.baja.sys.*;
import javax.baja.gx.*;

/**
 * The BColorCoding stores the colors mappings for 
 * segment type codes.
 *
 * @author    Brian Frank
 * @creation  6 Jul 01
 * @version   $Revision: 9$ $Date: 3/28/05 10:32:32 AM EST$
 * @since     Baja 1.0
 */
public class BColorCoding
  extends BComponent
{ 

  /*-
  
  class BColorCoding
  {
    properties
    {
      foreground: BColor
        default {[ BColor.black ]}
      whitespace: BColor
        default {[ BColor.make(192,192,192) ]}
      numberLiteral: BColor
        default {[ BColor.make(128, 0, 128) ]}
      stringLiteral: BColor
        default {[ BColor.make(128, 0, 128) ]}
      identifier: BColor
        default {[ BColor.black ]}
      keyword: BColor
        default {[ BColor.blue ]}
      preprocessor: BColor
        default {[ BColor.make(128, 0, 0) ]}
      bracket: BColor
        default {[ BColor.red ]}
      lineComment: BColor
        default {[ BColor.make(0, 128, 0) ]}
      multiLineComment: BColor
        default {[ BColor.make(0, 128, 0) ]}
      nonJavadocComment: BColor
        default {[ BColor.gray ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.text.BColorCoding(81811061)1.0$ @*/
/* Generated Wed Mar 17 08:36:32 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "foreground"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>foreground</code> property.
   * @see javax.baja.ui.text.BColorCoding#getForeground
   * @see javax.baja.ui.text.BColorCoding#setForeground
   */
  public static final Property foreground = newProperty(0, BColor.black,null);
  
  /**
   * Get the <code>foreground</code> property.
   * @see javax.baja.ui.text.BColorCoding#foreground
   */
  public BColor getForeground() { return (BColor)get(foreground); }
  
  /**
   * Set the <code>foreground</code> property.
   * @see javax.baja.ui.text.BColorCoding#foreground
   */
  public void setForeground(BColor v) { set(foreground,v,null); }

////////////////////////////////////////////////////////////////
// Property "whitespace"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>whitespace</code> property.
   * @see javax.baja.ui.text.BColorCoding#getWhitespace
   * @see javax.baja.ui.text.BColorCoding#setWhitespace
   */
  public static final Property whitespace = newProperty(0, BColor.make(192,192,192),null);
  
  /**
   * Get the <code>whitespace</code> property.
   * @see javax.baja.ui.text.BColorCoding#whitespace
   */
  public BColor getWhitespace() { return (BColor)get(whitespace); }
  
  /**
   * Set the <code>whitespace</code> property.
   * @see javax.baja.ui.text.BColorCoding#whitespace
   */
  public void setWhitespace(BColor v) { set(whitespace,v,null); }

////////////////////////////////////////////////////////////////
// Property "numberLiteral"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numberLiteral</code> property.
   * @see javax.baja.ui.text.BColorCoding#getNumberLiteral
   * @see javax.baja.ui.text.BColorCoding#setNumberLiteral
   */
  public static final Property numberLiteral = newProperty(0, BColor.make(128, 0, 128),null);
  
  /**
   * Get the <code>numberLiteral</code> property.
   * @see javax.baja.ui.text.BColorCoding#numberLiteral
   */
  public BColor getNumberLiteral() { return (BColor)get(numberLiteral); }
  
  /**
   * Set the <code>numberLiteral</code> property.
   * @see javax.baja.ui.text.BColorCoding#numberLiteral
   */
  public void setNumberLiteral(BColor v) { set(numberLiteral,v,null); }

////////////////////////////////////////////////////////////////
// Property "stringLiteral"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stringLiteral</code> property.
   * @see javax.baja.ui.text.BColorCoding#getStringLiteral
   * @see javax.baja.ui.text.BColorCoding#setStringLiteral
   */
  public static final Property stringLiteral = newProperty(0, BColor.make(128, 0, 128),null);
  
  /**
   * Get the <code>stringLiteral</code> property.
   * @see javax.baja.ui.text.BColorCoding#stringLiteral
   */
  public BColor getStringLiteral() { return (BColor)get(stringLiteral); }
  
  /**
   * Set the <code>stringLiteral</code> property.
   * @see javax.baja.ui.text.BColorCoding#stringLiteral
   */
  public void setStringLiteral(BColor v) { set(stringLiteral,v,null); }

////////////////////////////////////////////////////////////////
// Property "identifier"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>identifier</code> property.
   * @see javax.baja.ui.text.BColorCoding#getIdentifier
   * @see javax.baja.ui.text.BColorCoding#setIdentifier
   */
  public static final Property identifier = newProperty(0, BColor.black,null);
  
  /**
   * Get the <code>identifier</code> property.
   * @see javax.baja.ui.text.BColorCoding#identifier
   */
  public BColor getIdentifier() { return (BColor)get(identifier); }
  
  /**
   * Set the <code>identifier</code> property.
   * @see javax.baja.ui.text.BColorCoding#identifier
   */
  public void setIdentifier(BColor v) { set(identifier,v,null); }

////////////////////////////////////////////////////////////////
// Property "keyword"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>keyword</code> property.
   * @see javax.baja.ui.text.BColorCoding#getKeyword
   * @see javax.baja.ui.text.BColorCoding#setKeyword
   */
  public static final Property keyword = newProperty(0, BColor.blue,null);
  
  /**
   * Get the <code>keyword</code> property.
   * @see javax.baja.ui.text.BColorCoding#keyword
   */
  public BColor getKeyword() { return (BColor)get(keyword); }
  
  /**
   * Set the <code>keyword</code> property.
   * @see javax.baja.ui.text.BColorCoding#keyword
   */
  public void setKeyword(BColor v) { set(keyword,v,null); }

////////////////////////////////////////////////////////////////
// Property "preprocessor"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>preprocessor</code> property.
   * @see javax.baja.ui.text.BColorCoding#getPreprocessor
   * @see javax.baja.ui.text.BColorCoding#setPreprocessor
   */
  public static final Property preprocessor = newProperty(0, BColor.make(128, 0, 0),null);
  
  /**
   * Get the <code>preprocessor</code> property.
   * @see javax.baja.ui.text.BColorCoding#preprocessor
   */
  public BColor getPreprocessor() { return (BColor)get(preprocessor); }
  
  /**
   * Set the <code>preprocessor</code> property.
   * @see javax.baja.ui.text.BColorCoding#preprocessor
   */
  public void setPreprocessor(BColor v) { set(preprocessor,v,null); }

////////////////////////////////////////////////////////////////
// Property "bracket"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>bracket</code> property.
   * @see javax.baja.ui.text.BColorCoding#getBracket
   * @see javax.baja.ui.text.BColorCoding#setBracket
   */
  public static final Property bracket = newProperty(0, BColor.red,null);
  
  /**
   * Get the <code>bracket</code> property.
   * @see javax.baja.ui.text.BColorCoding#bracket
   */
  public BColor getBracket() { return (BColor)get(bracket); }
  
  /**
   * Set the <code>bracket</code> property.
   * @see javax.baja.ui.text.BColorCoding#bracket
   */
  public void setBracket(BColor v) { set(bracket,v,null); }

////////////////////////////////////////////////////////////////
// Property "lineComment"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>lineComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#getLineComment
   * @see javax.baja.ui.text.BColorCoding#setLineComment
   */
  public static final Property lineComment = newProperty(0, BColor.make(0, 128, 0),null);
  
  /**
   * Get the <code>lineComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#lineComment
   */
  public BColor getLineComment() { return (BColor)get(lineComment); }
  
  /**
   * Set the <code>lineComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#lineComment
   */
  public void setLineComment(BColor v) { set(lineComment,v,null); }

////////////////////////////////////////////////////////////////
// Property "multiLineComment"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>multiLineComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#getMultiLineComment
   * @see javax.baja.ui.text.BColorCoding#setMultiLineComment
   */
  public static final Property multiLineComment = newProperty(0, BColor.make(0, 128, 0),null);
  
  /**
   * Get the <code>multiLineComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#multiLineComment
   */
  public BColor getMultiLineComment() { return (BColor)get(multiLineComment); }
  
  /**
   * Set the <code>multiLineComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#multiLineComment
   */
  public void setMultiLineComment(BColor v) { set(multiLineComment,v,null); }

////////////////////////////////////////////////////////////////
// Property "nonJavadocComment"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nonJavadocComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#getNonJavadocComment
   * @see javax.baja.ui.text.BColorCoding#setNonJavadocComment
   */
  public static final Property nonJavadocComment = newProperty(0, BColor.gray,null);
  
  /**
   * Get the <code>nonJavadocComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#nonJavadocComment
   */
  public BColor getNonJavadocComment() { return (BColor)get(nonJavadocComment); }
  
  /**
   * Set the <code>nonJavadocComment</code> property.
   * @see javax.baja.ui.text.BColorCoding#nonJavadocComment
   */
  public void setNonJavadocComment(BColor v) { set(nonJavadocComment,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BColorCoding.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get the color used to draw the specified segment type.  
   * This method will automatically check if the segment 
   * appears inside a line or multi-line comment.
   */
  public BColor getColor(Segment segment)
  {
    if (segment.type == Segment.SPACES ||
        segment.type == Segment.TAB ||
        segment.type == Segment.NEWLINE)
      return getWhitespace();
        
    if (segment.isInMultiLineComment())
    {
      if (segment.isInNonJavadoc())
        return getNonJavadocComment();
      else
        return getMultiLineComment();
    }

    if (segment.isInStringLiteral())
      return getStringLiteral();
    
    if (segment.isInLineComment())
      return getLineComment();
    
    switch(segment.type)
    {
      case Segment.TEXT:           return getForeground();
      case Segment.NUMBER_LITERAL: return getNumberLiteral();
      case Segment.IDENTIFIER:     return getIdentifier();
      case Segment.KEYWORD:        return getKeyword();
      case Segment.PREPROCESSOR:   return getPreprocessor();
      case Segment.BRACKET:        return getBracket();
      default:                     return getForeground();
    }
  }
  
  public BIcon getIcon() { return icon; }
  static BIcon icon = BIcon.std("colorWheel.png");

}
