/*
 * Copyright 2005, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.spell;

import javax.baja.registry.*;
import javax.baja.sys.*;

/**
 * BSpellChecker.
 * 
 * @author    Andy Frank
 * @creation  5 Oct 2005
 * @version   $Revision: 1$ $Date: 11/29/05 11:03:02 AM EST$
 * @since     Baja 1.0
 */
public abstract class BSpellChecker
  extends BObject
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSpellChecker.class);
  
////////////////////////////////////////////////////////////////
// Factory
////////////////////////////////////////////////////////////////
  
  /**
   * Return the first installed SpellChecker or null
   * if no implemenation can be found.
   */
  public static BSpellChecker get()
  {
    if (instance == null)
    {
      TypeInfo[] types = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
      if (types.length > 0)
        instance = (BSpellChecker)types[0].getInstance();
    }
    return instance;
  }
  private static BSpellChecker instance = null;

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////
  
  /**
   * Check the given text for spelling mistakes.  If no
   * mistakes were found, return an empty array.
   */
  public abstract SpellingError[] check(String text);
}


