/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.shape;

import com.tridium.gx.util.GeomUtil;
import javax.baja.sys.*;
import javax.baja.gx.*;

/**
 * BLine renders a line between two points.
 *
 * @author    Brian Frank
 * @creation  2 Apr 04
 * @version   $Revision: 4$ $Date: 3/28/05 10:32:29 AM EST$
 * @since     Baja 1.0
 */
public class BLine
  extends BShape
{          

  /*-
  
  class BLine
  {
    properties
    {        
      geom: BLineGeom        
        -- The geometry of the Line.
        default {[ BLineGeom.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.shape.BLine(992605454)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "geom"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>geom</code> property.
   * The geometry of the Line.
   * @see javax.baja.ui.shape.BLine#getGeom
   * @see javax.baja.ui.shape.BLine#setGeom
   */
  public static final Property geom = newProperty(0, BLineGeom.NULL,null);
  
  /**
   * Get the <code>geom</code> property.
   * The geometry of the Line.
   * @see javax.baja.ui.shape.BLine#geom
   */
  public BLineGeom getGeom() { return (BLineGeom)get(geom); }
  
  /**
   * Set the <code>geom</code> property.
   * The geometry of the Line.
   * @see javax.baja.ui.shape.BLine#geom
   */
  public void setGeom(BLineGeom v) { set(geom,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLine.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
     
////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////
  
  /**
   * Construct with geometry, fill, stroke, and pen.
   */
  public BLine(ILineGeom geom, BBrush fill, BBrush stroke, BPen pen)
  {                           
    super(BLineGeom.make(geom), fill, stroke, pen);   
  } 

  /**
   * Construct with geometry.
   */
  public BLine(ILineGeom geom)
  {                        
    super(BLineGeom.make(geom));   
  } 

  /**
   * Default constructor.
   */
  public BLine()
  {
  } 
     
////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////
  
  /**
   * Return if the geometry contains the point.
   */                                          
  public boolean contains(double x, double y)
  {
    // getShapeGeom().peer() is a java.awt.geom.Line2D, but
    // java.awt.geom.Line2D.contains(x, y) will not work here,
    // since it is wired to always return false.
    //
    // Instead, we return true if the point is "near"
    // the line, using an arbitrary value to measure "nearness".

    BLineGeom geom = getGeom();
    double dist = GeomUtil.dist(
      new Point(x, y),
      new Point(geom.x1, geom.y1),
      new Point(geom.x2, geom.y2));

    return (dist <= GeomUtil.NEAR);
  }
  
////////////////////////////////////////////////////////////////
// Shape
////////////////////////////////////////////////////////////////
  
  /**
   * Return the geom property.
   */
  public BGeom getShapeGeom()
  {           
    return getGeom();
  }

  /**
   * Set geom property.
   */
  public void setShapeGeom(BGeom geom)
  {
    setGeom((BLineGeom)geom);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/line.png");
}



