/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.px;

import javax.baja.sys.*;

/**
 * Represents the status of a layer
 * 
 * @author    Mike Jarmy
 * @creation  26 Jul 09
 * @version   $Revision: 1$ $Date: 9/10/09 2:02:31 PM EDT$
 * @since     Niagara 3.0
 */
public final class BLayerStatus
  extends BFrozenEnum
{
  /*-
    enum BLayerStatus
    {
      range
      {
        normal,
        locked,
        invisible,
      }
    }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.px.BLayerStatus(1600643122)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for normal. */
  public static final int NORMAL = 0;
  /** Ordinal value for locked. */
  public static final int LOCKED = 1;
  /** Ordinal value for invisible. */
  public static final int INVISIBLE = 2;
  
  /** BLayerStatus constant for normal. */
  public static final BLayerStatus normal = new BLayerStatus(NORMAL);
  /** BLayerStatus constant for locked. */
  public static final BLayerStatus locked = new BLayerStatus(LOCKED);
  /** BLayerStatus constant for invisible. */
  public static final BLayerStatus invisible = new BLayerStatus(INVISIBLE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLayerStatus.class);
  
  /** Factory method with ordinal. */
  public static BLayerStatus make(int ordinal)
  {
    return (BLayerStatus)normal.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLayerStatus make(String tag)
  {
    return (BLayerStatus)normal.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLayerStatus(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BLayerStatus DEFAULT = BLayerStatus.normal;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
