/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.pane;

import javax.baja.sys.*;
import javax.baja.ui.*;
import javax.baja.ui.tree.*;
import com.tridium.ui.theme.*;

/**
 * BTreePane is a special BScrollPane which is designed 
 * to provide scrolling support to a BTree.
 *
 * @author    John Sublett
 * @creation  12 Dec 01
 * @version   $Revision: 8$ $Date: 3/28/05 10:32:29 AM EST$
 * @since     Baja 1.0
 */
public class BTreePane
  extends BScrollPane
{ 

  public static final Property content = newProperty(0, new BTree());

  /*-    
  
  class BTreePane
  {
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.pane.BTreePane(479297070)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTreePane.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with tree for content.
   */
  public BTreePane(BTree tree)
  {
    this();
    setContent(tree);
  }

  /**
   * No argument constructor.
   */
  public BTreePane()
  {
    getVscrollBar().setSnapToUnitIncrement(true);
  }

////////////////////////////////////////////////////////////////
// Tree
////////////////////////////////////////////////////////////////

  /**
   * Get the underlying BTree for this pane.
   */
  public BTree getTree()
  {
    return (BTree)getContent();
  }

////////////////////////////////////////////////////////////////
// Layout
////////////////////////////////////////////////////////////////

  /**
   * Layout the text editor.
   */
  public void doLayout(BWidget[] kids)
  {
    BTree tree = getTree();
    double rowHeight = tree.getRowHeight();

    BScrollBar vsb = getVscrollBar();
    vsb.setUnitIncrement((int)rowHeight);
    vsb.setBlockIncrement((int)(rowHeight * 5));
    
    BScrollBar hsb = getHscrollBar();
    hsb.setUnitIncrement((int)Theme.tree().getExpanderWidth());
    hsb.setBlockIncrement(hsb.getUnitIncrement() * 5);
    super.doLayout(kids);
  }
}
