/*
 * Copyright 2002, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.pane;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.ui.enums.*;

import com.tridium.ui.theme.Theme;

/**
 * BGridPane provides flexible layout based on a grid with a 
 * predefined number of columns. Cells are laid out left to
 * right, flowing to the next row based on the columnCount
 * property.
 * <p>
 * Row height is determined by the max preferred height of the
 * widgets in the row.  If uniformRowHeight is true then
 * all row heights are sized using the max row.
 * <p>
 * Column width is determined by the max preferred width of the
 * widgets in the column.  If uniformColumnWidth is true then
 * all column widths are sized using the max column.
 * <p>
 * <p>
 * If rowAlign is set to fill then all widgets in a given row are 
 * sized to fill the row height.  Otherwise the widgets use their 
 * preferred height and are aligned accordingly.
 * <p>
 * If columnAlign is set to fill then all widgets in a given column 
 * are sized to fill the column width.  Otherwise the widgets use 
 * their preferred width and are aligned accordingly.
 * <p>
 * The columnGap field specifies how many pixels to leave between columns.  
 * The rowGap field specifies how many pixels to leave been rows.
 * <p>
 * By default if the actual space of the pane is bigger than the preferred 
 * size, then the halign and valign fields determine where to put the 
 * extra space.  Or the stretchColumn and stretchRow properties may be 
 * used to indicate that a specific column or row should be stretched to 
 * fill the additional space.  Enabling the stretch feature trumps 
 * pane alignment.
 * <p>
 * If the colorRows field is true then alternating rows
 * are shaded to produce a stripped effect.
 *
 * @author    Brian Frank
 * @creation  7 Feb 02
 * @version   $Revision: 26$ $Date: 4/27/05 9:29:30 AM EDT$
 * @since     Baja 1.0
 */                              
public class BGridPane
  extends BPane
{

  /*-
  
  class BGridPane
  {
    properties
    {
      columnCount: int
        -- Number of columns in the grid
        default {[ 2 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BInteger.make(1)) ]}

      valign: BValign
        -- Determines how to use extra vertical space of entire pane.
        default {[ BValign.center ]}
  
      halign: BHalign
        -- Determines how to use extra horizontal space of entire pane.
        default {[ BHalign.center ]}

      rowAlign: BValign
        -- Determines how to use extra vertical space within rows.
        default {[ BValign.center ]}
  
      columnAlign: BHalign
        -- Determines how to use extra horizontal space within columns.
        default {[ BHalign.left ]}
      
      rowGap: double
        -- Space to leave between rows.
        default {[ 3 ]}

      columnGap: double
        -- Space to leave between columns.
        default {[ 3 ]}

      uniformRowHeight: boolean
        -- Make all rows in the pane have the same height.
        default {[ false ]}
       
      uniformColumnWidth: boolean
        -- Make all columns in the pane have the same width.
        default {[ false ]}

      stretchRow: int
        -- If the actual pane height is larger than the preferred 
        -- pane height, and this value is a valid zero indexed row, 
        -- then the specified row is used to fill remaining height.
        -- Using this feature trumps the valign property.  
        -- Use -1 to disable this feature.
        default {[ -1 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BInteger.make(-1)) ]}

      stretchColumn : int
        -- If the actual pane width is larger than the preferred 
        -- pane width, and this value is a valid zero indexed column, 
        -- then the specified column is used to fill remaining width.
        -- Using this feature trumps the halign property.  
        -- Use -1 to disable this feature.
        default {[ -1 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BInteger.make(-1)) ]}

      colorRows: boolean
         -- Paint color banding on rows.
         default {[ false ]}    
         
      bandBrush: BBrush
        -- The brush used to paint colored rows.
        default {[ BBrush.NULL ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.pane.BGridPane(4040467322)1.0$ @*/
/* Generated Sat Dec 17 22:53:03 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "columnCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>columnCount</code> property.
   * Number of columns in the grid
   * @see javax.baja.ui.pane.BGridPane#getColumnCount
   * @see javax.baja.ui.pane.BGridPane#setColumnCount
   */
  public static final Property columnCount = newProperty(0, 2,BFacets.make(BFacets.MIN, BInteger.make(1)));
  
  /**
   * Get the <code>columnCount</code> property.
   * Number of columns in the grid
   * @see javax.baja.ui.pane.BGridPane#columnCount
   */
  public int getColumnCount() { return getInt(columnCount); }
  
  /**
   * Set the <code>columnCount</code> property.
   * Number of columns in the grid
   * @see javax.baja.ui.pane.BGridPane#columnCount
   */
  public void setColumnCount(int v) { setInt(columnCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "valign"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valign</code> property.
   * Determines how to use extra vertical space of entire
   * pane.
   * @see javax.baja.ui.pane.BGridPane#getValign
   * @see javax.baja.ui.pane.BGridPane#setValign
   */
  public static final Property valign = newProperty(0, BValign.center,null);
  
  /**
   * Get the <code>valign</code> property.
   * Determines how to use extra vertical space of entire
   * pane.
   * @see javax.baja.ui.pane.BGridPane#valign
   */
  public BValign getValign() { return (BValign)get(valign); }
  
  /**
   * Set the <code>valign</code> property.
   * Determines how to use extra vertical space of entire
   * pane.
   * @see javax.baja.ui.pane.BGridPane#valign
   */
  public void setValign(BValign v) { set(valign,v,null); }

////////////////////////////////////////////////////////////////
// Property "halign"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>halign</code> property.
   * Determines how to use extra horizontal space of entire
   * pane.
   * @see javax.baja.ui.pane.BGridPane#getHalign
   * @see javax.baja.ui.pane.BGridPane#setHalign
   */
  public static final Property halign = newProperty(0, BHalign.center,null);
  
  /**
   * Get the <code>halign</code> property.
   * Determines how to use extra horizontal space of entire
   * pane.
   * @see javax.baja.ui.pane.BGridPane#halign
   */
  public BHalign getHalign() { return (BHalign)get(halign); }
  
  /**
   * Set the <code>halign</code> property.
   * Determines how to use extra horizontal space of entire
   * pane.
   * @see javax.baja.ui.pane.BGridPane#halign
   */
  public void setHalign(BHalign v) { set(halign,v,null); }

////////////////////////////////////////////////////////////////
// Property "rowAlign"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rowAlign</code> property.
   * Determines how to use extra vertical space within rows.
   * @see javax.baja.ui.pane.BGridPane#getRowAlign
   * @see javax.baja.ui.pane.BGridPane#setRowAlign
   */
  public static final Property rowAlign = newProperty(0, BValign.center,null);
  
  /**
   * Get the <code>rowAlign</code> property.
   * Determines how to use extra vertical space within rows.
   * @see javax.baja.ui.pane.BGridPane#rowAlign
   */
  public BValign getRowAlign() { return (BValign)get(rowAlign); }
  
  /**
   * Set the <code>rowAlign</code> property.
   * Determines how to use extra vertical space within rows.
   * @see javax.baja.ui.pane.BGridPane#rowAlign
   */
  public void setRowAlign(BValign v) { set(rowAlign,v,null); }

////////////////////////////////////////////////////////////////
// Property "columnAlign"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>columnAlign</code> property.
   * Determines how to use extra horizontal space within
   * columns.
   * @see javax.baja.ui.pane.BGridPane#getColumnAlign
   * @see javax.baja.ui.pane.BGridPane#setColumnAlign
   */
  public static final Property columnAlign = newProperty(0, BHalign.left,null);
  
  /**
   * Get the <code>columnAlign</code> property.
   * Determines how to use extra horizontal space within
   * columns.
   * @see javax.baja.ui.pane.BGridPane#columnAlign
   */
  public BHalign getColumnAlign() { return (BHalign)get(columnAlign); }
  
  /**
   * Set the <code>columnAlign</code> property.
   * Determines how to use extra horizontal space within
   * columns.
   * @see javax.baja.ui.pane.BGridPane#columnAlign
   */
  public void setColumnAlign(BHalign v) { set(columnAlign,v,null); }

////////////////////////////////////////////////////////////////
// Property "rowGap"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rowGap</code> property.
   * Space to leave between rows.
   * @see javax.baja.ui.pane.BGridPane#getRowGap
   * @see javax.baja.ui.pane.BGridPane#setRowGap
   */
  public static final Property rowGap = newProperty(0, 3,null);
  
  /**
   * Get the <code>rowGap</code> property.
   * Space to leave between rows.
   * @see javax.baja.ui.pane.BGridPane#rowGap
   */
  public double getRowGap() { return getDouble(rowGap); }
  
  /**
   * Set the <code>rowGap</code> property.
   * Space to leave between rows.
   * @see javax.baja.ui.pane.BGridPane#rowGap
   */
  public void setRowGap(double v) { setDouble(rowGap,v,null); }

////////////////////////////////////////////////////////////////
// Property "columnGap"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>columnGap</code> property.
   * Space to leave between columns.
   * @see javax.baja.ui.pane.BGridPane#getColumnGap
   * @see javax.baja.ui.pane.BGridPane#setColumnGap
   */
  public static final Property columnGap = newProperty(0, 3,null);
  
  /**
   * Get the <code>columnGap</code> property.
   * Space to leave between columns.
   * @see javax.baja.ui.pane.BGridPane#columnGap
   */
  public double getColumnGap() { return getDouble(columnGap); }
  
  /**
   * Set the <code>columnGap</code> property.
   * Space to leave between columns.
   * @see javax.baja.ui.pane.BGridPane#columnGap
   */
  public void setColumnGap(double v) { setDouble(columnGap,v,null); }

////////////////////////////////////////////////////////////////
// Property "uniformRowHeight"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>uniformRowHeight</code> property.
   * Make all rows in the pane have the same height.
   * @see javax.baja.ui.pane.BGridPane#getUniformRowHeight
   * @see javax.baja.ui.pane.BGridPane#setUniformRowHeight
   */
  public static final Property uniformRowHeight = newProperty(0, false,null);
  
  /**
   * Get the <code>uniformRowHeight</code> property.
   * Make all rows in the pane have the same height.
   * @see javax.baja.ui.pane.BGridPane#uniformRowHeight
   */
  public boolean getUniformRowHeight() { return getBoolean(uniformRowHeight); }
  
  /**
   * Set the <code>uniformRowHeight</code> property.
   * Make all rows in the pane have the same height.
   * @see javax.baja.ui.pane.BGridPane#uniformRowHeight
   */
  public void setUniformRowHeight(boolean v) { setBoolean(uniformRowHeight,v,null); }

////////////////////////////////////////////////////////////////
// Property "uniformColumnWidth"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>uniformColumnWidth</code> property.
   * Make all columns in the pane have the same width.
   * @see javax.baja.ui.pane.BGridPane#getUniformColumnWidth
   * @see javax.baja.ui.pane.BGridPane#setUniformColumnWidth
   */
  public static final Property uniformColumnWidth = newProperty(0, false,null);
  
  /**
   * Get the <code>uniformColumnWidth</code> property.
   * Make all columns in the pane have the same width.
   * @see javax.baja.ui.pane.BGridPane#uniformColumnWidth
   */
  public boolean getUniformColumnWidth() { return getBoolean(uniformColumnWidth); }
  
  /**
   * Set the <code>uniformColumnWidth</code> property.
   * Make all columns in the pane have the same width.
   * @see javax.baja.ui.pane.BGridPane#uniformColumnWidth
   */
  public void setUniformColumnWidth(boolean v) { setBoolean(uniformColumnWidth,v,null); }

////////////////////////////////////////////////////////////////
// Property "stretchRow"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stretchRow</code> property.
   * If the actual pane height is larger than the preferred
   * pane height, and this value is a valid zero indexed
   * row, then the specified row is used to fill remaining
   * height. Using this feature trumps the valign property.
   * Use -1 to disable this feature.
   * @see javax.baja.ui.pane.BGridPane#getStretchRow
   * @see javax.baja.ui.pane.BGridPane#setStretchRow
   */
  public static final Property stretchRow = newProperty(0, -1,BFacets.make(BFacets.MIN, BInteger.make(-1)));
  
  /**
   * Get the <code>stretchRow</code> property.
   * If the actual pane height is larger than the preferred
   * pane height, and this value is a valid zero indexed
   * row, then the specified row is used to fill remaining
   * height. Using this feature trumps the valign property.
   * Use -1 to disable this feature.
   * @see javax.baja.ui.pane.BGridPane#stretchRow
   */
  public int getStretchRow() { return getInt(stretchRow); }
  
  /**
   * Set the <code>stretchRow</code> property.
   * If the actual pane height is larger than the preferred
   * pane height, and this value is a valid zero indexed
   * row, then the specified row is used to fill remaining
   * height. Using this feature trumps the valign property.
   * Use -1 to disable this feature.
   * @see javax.baja.ui.pane.BGridPane#stretchRow
   */
  public void setStretchRow(int v) { setInt(stretchRow,v,null); }

////////////////////////////////////////////////////////////////
// Property "stretchColumn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>stretchColumn</code> property.
   * If the actual pane width is larger than the preferred
   * pane width, and this value is a valid zero indexed
   * column, then the specified column is used to fill remaining width. Using this feature trumps the halign property. Use -1 to disable this feature.
   * @see javax.baja.ui.pane.BGridPane#getStretchColumn
   * @see javax.baja.ui.pane.BGridPane#setStretchColumn
   */
  public static final Property stretchColumn = newProperty(0, -1,BFacets.make(BFacets.MIN, BInteger.make(-1)));
  
  /**
   * Get the <code>stretchColumn</code> property.
   * If the actual pane width is larger than the preferred
   * pane width, and this value is a valid zero indexed
   * column, then the specified column is used to fill remaining width. Using this feature trumps the halign property. Use -1 to disable this feature.
   * @see javax.baja.ui.pane.BGridPane#stretchColumn
   */
  public int getStretchColumn() { return getInt(stretchColumn); }
  
  /**
   * Set the <code>stretchColumn</code> property.
   * If the actual pane width is larger than the preferred
   * pane width, and this value is a valid zero indexed
   * column, then the specified column is used to fill remaining width. Using this feature trumps the halign property. Use -1 to disable this feature.
   * @see javax.baja.ui.pane.BGridPane#stretchColumn
   */
  public void setStretchColumn(int v) { setInt(stretchColumn,v,null); }

////////////////////////////////////////////////////////////////
// Property "colorRows"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>colorRows</code> property.
   * Paint color banding on rows.
   * @see javax.baja.ui.pane.BGridPane#getColorRows
   * @see javax.baja.ui.pane.BGridPane#setColorRows
   */
  public static final Property colorRows = newProperty(0, false,null);
  
  /**
   * Get the <code>colorRows</code> property.
   * Paint color banding on rows.
   * @see javax.baja.ui.pane.BGridPane#colorRows
   */
  public boolean getColorRows() { return getBoolean(colorRows); }
  
  /**
   * Set the <code>colorRows</code> property.
   * Paint color banding on rows.
   * @see javax.baja.ui.pane.BGridPane#colorRows
   */
  public void setColorRows(boolean v) { setBoolean(colorRows,v,null); }

////////////////////////////////////////////////////////////////
// Property "bandBrush"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>bandBrush</code> property.
   * The brush used to paint colored rows.
   * @see javax.baja.ui.pane.BGridPane#getBandBrush
   * @see javax.baja.ui.pane.BGridPane#setBandBrush
   */
  public static final Property bandBrush = newProperty(0, BBrush.NULL,null);
  
  /**
   * Get the <code>bandBrush</code> property.
   * The brush used to paint colored rows.
   * @see javax.baja.ui.pane.BGridPane#bandBrush
   */
  public BBrush getBandBrush() { return (BBrush)get(bandBrush); }
  
  /**
   * Set the <code>bandBrush</code> property.
   * The brush used to paint colored rows.
   * @see javax.baja.ui.pane.BGridPane#bandBrush
   */
  public void setBandBrush(BBrush v) { set(bandBrush,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BGridPane.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Constructor with columnCount.
   */
  public BGridPane(int columnCount)
  {                                
    setColumnCount(columnCount);
  }

  /**
   * Default constructor.
   */
  public BGridPane()
  {
  }

  /**
   * Constructor with columnCount and widgets.
   * Each widget will be added as a child of this pane.
   */
  public BGridPane(int columnCount, BWidget[] childWidgets)
  {                                
    setColumnCount(columnCount);

    for (int i = 0; i < childWidgets.length; i++)
      add(null, childWidgets[i]);
  }

  /**
   * Constructor with widgets.
   * Each widget will be added as a child of this pane.
   */
  public BGridPane(BWidget[] childWidgets)
  {                                
    for (int i = 0; i < childWidgets.length; i++)
      add(null, childWidgets[i]);
  }

////////////////////////////////////////////////////////////////
// Layout
////////////////////////////////////////////////////////////////

  /**
   * Compute the preferred size of the pane.
   */  
  public void computePreferredSize()
  {
    BWidget[] kids = getChildWidgets();
    double hgap = getColumnGap();
    double vgap = getRowGap();
    
    // row count is always computed
    int columns = getColumnCount();
    if (columns < 1) columns = 1;
    int rows = kids.length/columns;
    if (kids.length % columns > 0) rows++;
    
    cw = new double[columns];
    rh = new double[rows];
    double maxw = 0;
    double maxh = 0;

    int i = 0;
    rowloop: for(int r=0; r<rh.length; ++r)
    {
      for(int c=0; c<cw.length; ++c)
      {
        if (i >= kids.length) break rowloop;
        BWidget kid = kids[i++];
        if (kid.isVisible())
        {
          kid.computePreferredSize();
          cw[c] = Math.max(cw[c], kid.getPreferredWidth());
          rh[r] = Math.max(rh[r], kid.getPreferredHeight());
          maxw = Math.max(cw[c], maxw);
          maxh = Math.max(rh[r], maxh);
        }
      }
    }
    
    // uniform column widths
    if (getUniformColumnWidth())
      for(int c=0; c<cw.length; ++c) cw[c] = maxw;

    // uniform row heights
    if (getUniformRowHeight())
      for(int r=0; r<rh.length; ++r) rh[r] = maxh;
    
    double pw = 0, ph = 0;
    for(i=0; i<cw.length; ++i) { if (i>0) pw += hgap; pw += cw[i]; }
    for(i=0; i<rh.length; ++i) { if (i>0) ph += vgap; ph += rh[i]; }
    
    setPreferredSize(pw, ph);
  }
  
  /**
   * Layout the pane.
   */
  public void doLayout(BWidget[] kids)
  {
    computePreferredSize();
    double pw = getPreferredWidth();
    double ph = getPreferredHeight();
    double w = getWidth();
    double h = getHeight();
    double hgap = getColumnGap();
    double vgap = getRowGap();
    int hlayout = getColumnAlign().getOrdinal();
    int vlayout = getRowAlign().getOrdinal();
    int stretchRow = getStretchRow();
    int stretchCol = getStretchColumn();
    
    // x offset for halign
    xo = 0;
    if (w > pw && stretchCol < 0) 
    {
      int hpalign = getHalign().getOrdinal();
      if (hpalign == BHalign.CENTER) xo = (w-pw)/2; 
      if (hpalign == BHalign.RIGHT) xo = w-pw;
    }

    // y offset for valign
    yo = 0;
    if (h > ph && stretchRow < 0) 
    {
      int vpalign = getValign().getOrdinal();
      if (vpalign == BValign.CENTER) yo = (h-ph)/2; 
      if (vpalign == BValign.BOTTOM) yo = h-ph;
    }
    
    // insert horizontal stretch pixels
    if (stretchCol >= 0 && stretchCol < cw.length && w > pw)
      cw[stretchCol] += w - pw;
      
    // insert vertical stretch pixels
    if (stretchRow >= 0 && stretchRow < rh.length && h > ph)
      rh[stretchRow] += h - ph;
    
    // layout children
    int i = 0;
    double cx = 0, ry = 0;
    rowloop: for(int r=0; r<rh.length; ++r)
    {
      cx = 0;
      for(int c=0; c<cw.length; ++c)
      {
        if (i >= kids.length) break rowloop;
        BWidget kid = kids[i++];
        double colw = cw[c];
        double rowh = rh[r];
        
        double kph = kid.getPreferredHeight();
        double kx = xo + cx;
        double ky = yo + ry;
        double kw = colw;
        double kh = rowh;
                
        if (hlayout != BHalign.FILL)
        {
          kw = kid.getPreferredWidth();
          if (hlayout == BHalign.CENTER) kx = xo + cx + (colw-kw)/2; 
          if (hlayout == BHalign.RIGHT) kx = xo + cx + colw - kw;
        }

        if (vlayout != BValign.FILL)
        {
          kh = kid.getPreferredHeight();
          if (vlayout == BValign.CENTER) ky = yo + ry + (rowh-kh)/2; 
          if (vlayout == BValign.BOTTOM) ky = yo + ry + rowh - kh;
        }
                
        kid.setBounds((int)kx, (int)ky, (int)kw, (int)kh);
        cx += cw[c] + hgap;
      }
      ry += rh[r] + vgap;
    }    
  }

////////////////////////////////////////////////////////////////
// Paint
////////////////////////////////////////////////////////////////  

  public void paint(Graphics g)
  {
    double vgap = getRowGap();
    double w = getWidth();
    
    Theme.pane().paintBackground(g, this);
    
    if (getColorRows())
    {
      g.setBrush(Theme.gridPane().getBandBrush(this)); 
      double vgapHalf = vgap/2;
      double ry = yo;
      for(int r=0; r<rh.length; r++)
      {
        if (r % 2 == 0) g.fillRect(0, ry-vgapHalf, w, rh[r]+vgap);
        ry += rh[r] + vgap;
      }
    } 
    
    paintChildren(g);
  }
  
  public String getStyleSelector() {
    return "pane grid-pane";
  }

////////////////////////////////////////////////////////////////
// Trap
////////////////////////////////////////////////////////////////  

  public void changed(Property prop, Context context) 
  {
    relayout();
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/gridPane.png");  

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  double xo, yo;              // x and y offsets
  double[] cw = new double[0];   // column widths
  double[] rh = new double[0];   // row heights
  
}
