/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.ui.pane;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.*;

/**
 * BConstrainedPane is a pane with a constrained size.  It allows the
 * pane to be restricted by minimum width, maximum width, minimum height,
 * and maximum height.
 *
 * @author    John Sublett
 * @creation  26 Apr 2003
 * @version   $Revision: 9$ $Date: 7/13/11 3:13:19 PM EDT$
 * @since     Baja 1.0
 */
public class BConstrainedPane
  extends BPane
{
  /*-
  
  class BConstrainedPane
  {
    properties
    {
      content: BWidget
        -- The content of the pane.
        default {[ new BNullWidget() ]}
      
      minSize: BSize
        -- The smallest size that the pane will return as its
        -- preferred size.
        default {[ BSize.make(0, 0) ]}
      
      maxSize: BSize
        -- The largest size that the pane will return as its
        -- preferred size.
        default {[ BSize.make(Integer.MAX_VALUE, Integer.MAX_VALUE) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.pane.BConstrainedPane(3668633801)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "content"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>content</code> property.
   * The content of the pane.
   * @see javax.baja.ui.pane.BConstrainedPane#getContent
   * @see javax.baja.ui.pane.BConstrainedPane#setContent
   */
  public static final Property content = newProperty(0, new BNullWidget(),null);
  
  /**
   * Get the <code>content</code> property.
   * The content of the pane.
   * @see javax.baja.ui.pane.BConstrainedPane#content
   */
  public BWidget getContent() { return (BWidget)get(content); }
  
  /**
   * Set the <code>content</code> property.
   * The content of the pane.
   * @see javax.baja.ui.pane.BConstrainedPane#content
   */
  public void setContent(BWidget v) { set(content,v,null); }

////////////////////////////////////////////////////////////////
// Property "minSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minSize</code> property.
   * The smallest size that the pane will return as its
   * preferred size.
   * @see javax.baja.ui.pane.BConstrainedPane#getMinSize
   * @see javax.baja.ui.pane.BConstrainedPane#setMinSize
   */
  public static final Property minSize = newProperty(0, BSize.make(0, 0),null);
  
  /**
   * Get the <code>minSize</code> property.
   * The smallest size that the pane will return as its
   * preferred size.
   * @see javax.baja.ui.pane.BConstrainedPane#minSize
   */
  public BSize getMinSize() { return (BSize)get(minSize); }
  
  /**
   * Set the <code>minSize</code> property.
   * The smallest size that the pane will return as its
   * preferred size.
   * @see javax.baja.ui.pane.BConstrainedPane#minSize
   */
  public void setMinSize(BSize v) { set(minSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxSize</code> property.
   * The largest size that the pane will return as its preferred size.
   * @see javax.baja.ui.pane.BConstrainedPane#getMaxSize
   * @see javax.baja.ui.pane.BConstrainedPane#setMaxSize
   */
  public static final Property maxSize = newProperty(0, BSize.make(Integer.MAX_VALUE, Integer.MAX_VALUE),null);
  
  /**
   * Get the <code>maxSize</code> property.
   * The largest size that the pane will return as its preferred size.
   * @see javax.baja.ui.pane.BConstrainedPane#maxSize
   */
  public BSize getMaxSize() { return (BSize)get(maxSize); }
  
  /**
   * Set the <code>maxSize</code> property.
   * The largest size that the pane will return as its preferred size.
   * @see javax.baja.ui.pane.BConstrainedPane#maxSize
   */
  public void setMaxSize(BSize v) { set(maxSize,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BConstrainedPane.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////


  /**
   * Default constructor.
   */
  public BConstrainedPane()
  {
  }

  /**
   * Constructor with content.
   *
   * @param content The widget that will occupy the entire pane.
   */
  public BConstrainedPane(BWidget content)
  {
    setContent(content);
  }

  /**
   * Constructor with content and max width and height.
   *
   * @param content The widget that will occupy the entire pane.
   * @since Niagara 3.7
   */
  public BConstrainedPane(BWidget content, double maxWidth, double maxHeight)
  {
    setContent(content);
    setMaxSize(maxWidth, maxHeight);
  }
  
////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get <code>minSize.width</code>
   */
  public double getMinWidth() 
  {
    return getMinSize().width();
  }

  /**
   * Get <code>minSize.height</code>
   */
  public double getMinHeight() 
  {
    return getMinSize().height();
  }

  /**
   * Get <code>maxSize.width</code>
   */
  public double getMaxWidth() 
  {
    return getMaxSize().width();
  }

  /**
   * Get <code>maxSize.height</code>
   */
  public double getMaxHeight() 
  {
    return getMaxSize().height();
  }                                    
  
  /**
   * Set the minSize property.
   */
  public void setMinSize(double w, double h)
  {
    setMinSize(BSize.make(w, h));
  }

  /**
   * Set the maxSize property.
   */
  public void setMaxSize(double w, double h)
  {
    setMaxSize(BSize.make(w, h));
  }

  /**
   * Set <code>minSize.width</code>.
   */
  public void setMinWidth(double w) 
  {
    setMinSize(BSize.make(w, getMinHeight()));
  }

  /**
   * Set <code>minSize.height</code>.
   */
  public void setMinHeight(double h) 
  {
    setMinSize(BSize.make(getMinWidth(), h));
  }

  /**
   * Set <code>maxSize.width</code>.
   */
  public void setMaxWidth(double w) 
  {
    setMaxSize(BSize.make(w, getMaxHeight()));
  }

  /**
   * Set <code>maxSize.height</code>.
   */
  public void setMaxHeight(double h) 
  {
    setMaxSize(BSize.make(getMaxWidth(), h));
  }                         
  
  /**
   * Set both minSize and maxSize
   */
  public void setFixedSize(double w, double h)
  {                             
    setFixedSize(BSize.make(w, h));
  }

  /**
   * Set both minSize and maxSize
   */
  public void setFixedSize(BSize size)
  {                             
    setMinSize(size);
    setMaxSize(size);
  }
  
////////////////////////////////////////////////////////////////
// Widget
////////////////////////////////////////////////////////////////

  /**
   * Compute the preferred size of the pane accounting for the
   * configured minimum and maximum dimensions.
   */
  public void computePreferredSize()
  {
    double w;
    double h;
    
    BWidget content = getContent();
    if (content.isNull())
    {
      w = getMinWidth();
      h = getMinHeight();
    }
    else
    {
      content.computePreferredSize();

      w = content.getPreferredWidth();
      w = Math.max(w, getMinWidth());
      w = Math.min(w, getMaxWidth());
      
      h = content.getPreferredHeight();
      h = Math.max(h, getMinHeight());
      h = Math.min(h, getMaxHeight());
    }
    
    setPreferredSize(w, h);
  }

  /**
   * Layout the pane.
   */
  public void doLayout(BWidget[] kids)
  {
    BWidget content = getContent();
    if (content.isNull())
    {
      content.setBounds(0,0,0,0);
    }
    else
    {
      content.setBounds(0, 0, getWidth(), getHeight());
    }
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/constrainedPane.png");  

}
