/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.options;

import javax.baja.nre.util.IFilter;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIMruWidget is the interface implemented by widget controls
 * which use BMruOptions to store a persistent history of the
 * last selections.
 *
 * @author    Brian Frank       
 * @creation  20 Dec 03
 * @version   $Revision: 2$ $Date: 1/29/04 11:30:13 AM EST$
 * @since     Baja 1.0
 */
public interface BIMruWidget
  extends BInterface
{ 

  /**
   * Get the MRU options name used to key the BMruOptions instance.
   */
  public String getMruOptionsName();

  /**
   * Set the MRU options name used to key the BMruOptions instance.
   */
  public void setMruOptionsName(String mruName);
  
  /**
   * Get the options by name using <code>getMruOptionsName()</code>.
   */
  public BMruOptions getMruOptions();

  /**
   * Get the filter.
   */
  public IFilter getFilter();

  /**
   * Set the filter.
   */
  public void setFilter(IFilter filter);

  public static final Type TYPE = Sys.loadType(BIMruWidget.class);
  
} 

