/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.menu;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BISubMenuItem represents an interface for manipulating a BMenuItem that has a submenu
 * @author    Danesh Kamal
 * @creation  1/15/2014
 * @version   1
 * @since     Niagara 4.0
 */
public interface BISubMenuItem extends BIMenuItem
{
  /**
   * Get the sub-menu for the menu item
   * @return
   */
  public BIMenu getSubMenu();

  /**
   * Set the sub-menu for the menu item
   * @param subMenu
   */
  public void setSubMenu(BIMenu subMenu);

  public static final Type TYPE = Sys.loadType(BISubMenuItem.class);

}
