/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.sys.*;

/**
 * BScaleMode defines how scale to fit works.
 *
 * @author    Brian Frank
 * @creation  2 Apr 04
 * @version   $Revision: 3$ $Date: 3/23/05 11:29:07 AM EST$
 * @since     Baja 1.0
 */
public final class BScaleMode
  extends BFrozenEnum
{

  /*-
  
  enum BScaleMode
  {
    range
    {
      none,
      fit,
      fitRatio,
      fitWidth,
      fitHeight,
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.enums.BScaleMode(1859054296)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for none. */
  public static final int NONE = 0;
  /** Ordinal value for fit. */
  public static final int FIT = 1;
  /** Ordinal value for fitRatio. */
  public static final int FIT_RATIO = 2;
  /** Ordinal value for fitWidth. */
  public static final int FIT_WIDTH = 3;
  /** Ordinal value for fitHeight. */
  public static final int FIT_HEIGHT = 4;
  
  /** BScaleMode constant for none. */
  public static final BScaleMode none = new BScaleMode(NONE);
  /** BScaleMode constant for fit. */
  public static final BScaleMode fit = new BScaleMode(FIT);
  /** BScaleMode constant for fitRatio. */
  public static final BScaleMode fitRatio = new BScaleMode(FIT_RATIO);
  /** BScaleMode constant for fitWidth. */
  public static final BScaleMode fitWidth = new BScaleMode(FIT_WIDTH);
  /** BScaleMode constant for fitHeight. */
  public static final BScaleMode fitHeight = new BScaleMode(FIT_HEIGHT);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BScaleMode.class);
  
  /** Factory method with ordinal. */
  public static BScaleMode make(int ordinal)
  {
    return (BScaleMode)none.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BScaleMode make(String tag)
  {
    return (BScaleMode)none.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BScaleMode(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BScaleMode DEFAULT = BScaleMode.none;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
}

