/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.sys.*;

/**
 * BOrientation defines a widget's orientation as
 * either horizontal or vertical.
 *
 * @author    Brian Frank
 * @creation  21 Nov 00
 * @version   $Revision: 2$ $Date: 3/23/05 11:29:07 AM EST$
 * @since     Baja 1.0
 */
public final class BOrientation
  extends BFrozenEnum
{
  /*-
  
  enum BOrientation
  {
    range
    {
      horizontal,
      vertical
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.enums.BOrientation(507474751)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for horizontal. */
  public static final int HORIZONTAL = 0;
  /** Ordinal value for vertical. */
  public static final int VERTICAL = 1;
  
  /** BOrientation constant for horizontal. */
  public static final BOrientation horizontal = new BOrientation(HORIZONTAL);
  /** BOrientation constant for vertical. */
  public static final BOrientation vertical = new BOrientation(VERTICAL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOrientation.class);
  
  /** Factory method with ordinal. */
  public static BOrientation make(int ordinal)
  {
    return (BOrientation)horizontal.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BOrientation make(String tag)
  {
    return (BOrientation)horizontal.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BOrientation(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BOrientation DEFAULT = BOrientation.horizontal;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get the orientation value that is opposite of this one.
   */
  public BOrientation getOpposite()
  {
    if (this == BOrientation.horizontal)
      return BOrientation.vertical;
    else
      return BOrientation.horizontal;
  }
}

