/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.sys.*;

/**
 * BHalign defines an enumeration for horizontal 
 * justification: left, center, right, fill.
 *
 * @author    Brian Frank
 * @creation  1 Dec 00
 * @version   $Revision: 4$ $Date: 3/23/05 11:29:07 AM EST$
 * @since     Baja 1.0
 */
public final class BHalign
  extends BFrozenEnum
{

  /*-
  
  enum BHalign
  {
    range
    {
      left,
      center,
      right,
      fill
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.enums.BHalign(4138291075)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for left. */
  public static final int LEFT = 0;
  /** Ordinal value for center. */
  public static final int CENTER = 1;
  /** Ordinal value for right. */
  public static final int RIGHT = 2;
  /** Ordinal value for fill. */
  public static final int FILL = 3;
  
  /** BHalign constant for left. */
  public static final BHalign left = new BHalign(LEFT);
  /** BHalign constant for center. */
  public static final BHalign center = new BHalign(CENTER);
  /** BHalign constant for right. */
  public static final BHalign right = new BHalign(RIGHT);
  /** BHalign constant for fill. */
  public static final BHalign fill = new BHalign(FILL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHalign.class);
  
  /** Factory method with ordinal. */
  public static BHalign make(int ordinal)
  {
    return (BHalign)left.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BHalign make(String tag)
  {
    return (BHalign)left.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BHalign(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BHalign DEFAULT = BHalign.left;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
}

