/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.enums;

import javax.baja.sys.*;

/**
 * BDegradeBehavior specifies how a binding should behave 
 * when the binding returns true for isDegrated().
 *
 * @author    Brian Frank
 * @creation  21 Feb 06
 * @version   $Revision: 1$ $Date: 2/21/06 2:46:36 PM EST$
 * @since     Baja 1.0
 */
public final class BDegradeBehavior
  extends BFrozenEnum
{

  /*-
  
  enum BDegradeBehavior
  {
    range
    {
      none,
      disable,
      hide,
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.enums.BDegradeBehavior(3363452630)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for none. */
  public static final int NONE = 0;
  /** Ordinal value for disable. */
  public static final int DISABLE = 1;
  /** Ordinal value for hide. */
  public static final int HIDE = 2;
  
  /** BDegradeBehavior constant for none. */
  public static final BDegradeBehavior none = new BDegradeBehavior(NONE);
  /** BDegradeBehavior constant for disable. */
  public static final BDegradeBehavior disable = new BDegradeBehavior(DISABLE);
  /** BDegradeBehavior constant for hide. */
  public static final BDegradeBehavior hide = new BDegradeBehavior(HIDE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDegradeBehavior.class);
  
  /** Factory method with ordinal. */
  public static BDegradeBehavior make(int ordinal)
  {
    return (BDegradeBehavior)none.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BDegradeBehavior make(String tag)
  {
    return (BDegradeBehavior)none.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BDegradeBehavior(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BDegradeBehavior DEFAULT = BDegradeBehavior.none;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
}

