/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.bookmark;

import javax.baja.sys.*;
import javax.baja.ui.util.*;

/**
 * BBookmarkFolder contains BBookmarkItems.
 *
 * @author    Andy Frank
 * @creation  06 Feb 03
 * @version   $Revision: 5$ $Date: 11/22/06 4:41:17 PM EST$
 * @since     Baja 1.0
 */
public class BBookmarkFolder
  extends BBookmarkItem
{ 
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBookmarkFolder.class);

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBookmarkFolder() 
  {
    setText(UiLexicon.bajaui().getText("bookmarks.folder"));
    setIcon(defaultIcon);
  }

  public BBookmarkFolder(String displayName)
  {
    setText(displayName);
    setIcon(defaultIcon);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  public boolean isChildLegal(BComponent child)
  {
    return (child instanceof BBookmarkItem);
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private static BIcon defaultIcon = BIcon.std("bookmarkFolder.png");
}
