/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui.bookmark;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.ui.util.*;

/**
 * BBookmark describes a bookmark.
 *
 * @author    Andy Frank
 * @creation  02 Dec 02
 * @version   $Revision: 8$ $Date: 11/22/06 4:41:17 PM EST$
 * @since     Baja 1.0
 */
public class BBookmark
  extends BBookmarkItem
{ 
  /*-
  class BBookmark
  {
    properties
    {
      bookmarkOrd: BOrd
        -- The ord that points to the bookmark location.
        default {[ BOrd.DEFAULT ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.bookmark.BBookmark(3937625829)1.0$ @*/
/* Generated Sat Dec 17 22:53:01 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "bookmarkOrd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>bookmarkOrd</code> property.
   * The ord that points to the bookmark location.
   * @see javax.baja.ui.bookmark.BBookmark#getBookmarkOrd
   * @see javax.baja.ui.bookmark.BBookmark#setBookmarkOrd
   */
  public static final Property bookmarkOrd = newProperty(0, BOrd.DEFAULT,null);
  
  /**
   * Get the <code>bookmarkOrd</code> property.
   * The ord that points to the bookmark location.
   * @see javax.baja.ui.bookmark.BBookmark#bookmarkOrd
   */
  public BOrd getBookmarkOrd() { return (BOrd)get(bookmarkOrd); }
  
  /**
   * Set the <code>bookmarkOrd</code> property.
   * The ord that points to the bookmark location.
   * @see javax.baja.ui.bookmark.BBookmark#bookmarkOrd
   */
  public void setBookmarkOrd(BOrd v) { set(bookmarkOrd,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBookmark.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Default Constructor.
   */
  public BBookmark() 
  {
    setText(UiLexicon.bajaui().getText("bookmarks.bookmark"));
  }

  /**
   * Create a new Bookmark.
   */
  public BBookmark(String displayName)
  {
    setText(displayName);
  }

  /**
   * Create a new Bookmark.
   */
  public BBookmark(String displayName, BOrd bookmark)
  {
    setText(displayName);
    setBookmarkOrd(bookmark);
  }

  /**
   * Create a new Bookmark.
   */
  public BBookmark(String displayName, BOrd bookmark, BIcon icon)
  {
    setText(displayName);
    setBookmarkOrd(bookmark);
    setIcon(icon);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public boolean isChildLegal(BComponent child) { return false; }
}
