/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.gx.*;
import javax.baja.sys.*;
import com.tridium.ui.theme.*;
import com.tridium.ui.theme.custom.nss.StyleUtils;

/**
 * BToggleButton provides a two-state widget which may
 * be selected and unselected.
 *
 * @author    Brian Frank       
 * @creation  2 Dec 00
 * @version   $Revision: 27$ $Date: 6/11/07 12:41:32 PM EDT$
 * @since     Baja 1.0
 */
public class BToggleButton
  extends BAbstractButton
{ 

  /*-    
  
  class BToggleButton
  {
    properties
    {
      selected: boolean
        -- The selected property indicates whether the 
        -- toggle is currently selected or unselected.
        default {[ false ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BToggleButton(3727805953)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "selected"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selected</code> property.
   * The selected property indicates whether the toggle
   * is currently selected or unselected.
   * @see javax.baja.ui.BToggleButton#getSelected
   * @see javax.baja.ui.BToggleButton#setSelected
   */
  public static final Property selected = newProperty(0, false,null);
  
  /**
   * Get the <code>selected</code> property.
   * The selected property indicates whether the toggle
   * is currently selected or unselected.
   * @see javax.baja.ui.BToggleButton#selected
   */
  public boolean getSelected() { return getBoolean(selected); }
  
  /**
   * Set the <code>selected</code> property.
   * The selected property indicates whether the toggle
   * is currently selected or unselected.
   * @see javax.baja.ui.BToggleButton#selected
   */
  public void setSelected(boolean v) { setBoolean(selected,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BToggleButton.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Construct a toggle button with the specified label text.
   */
  public BToggleButton(String text)
  {
    setText(text);
  }

  /**
   * Construct a toggle button with the specified label text and image.
   */
  public BToggleButton(BImage image, String text)
  {
    setText(text);
    setImage(image);
  }

  /**
   * Construct a toggle button with the specified label 
   * text and selection state.
   */
  public BToggleButton(String text, boolean selected)
  {
    setText(text);
    setSelected(selected);
  }
  
  /**
   * Construct a toggle button with the specified label text
   * and image and selection state.
   */
  public BToggleButton(BImage image, String text, boolean selected)
  {
    setText(text);
    setImage(image);
    setSelected(selected);
  }
  
  /**
   * Constructor with ToggleCommand.  The label and icon
   * of the command are set using specified flags, and
   * the button is automatically registered with the
   * command.
   */
  public BToggleButton(ToggleCommand cmd, boolean useLabel, boolean useIcon)
  {
    setCommand(cmd, useLabel, useIcon);  
  }

  /**
   * Constructor with ToggleCommand where useLabel and useIcon is true.
   */
  public BToggleButton(Command cmd)
  {    
    setCommand(cmd, true, true);
  }

  /**
   * No argument constructor.
   */
  public BToggleButton()
  {
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Return if the toggle is currently selected.
   */
  public boolean isSelected() { return getBoolean(selected); }

  /**
   * If the button has a command associated with 
   * it, return the Command instance, otherwise
   * return null.
   */
  public Command getCommand()
  {
    return command;
  }

  /**
   * Install the command object for this button.  This
   * does *not* automatically change the label or icon
   * for this button.
   */
  public void setCommand(Command command, boolean useLabel, boolean useIcon)
  {    
    if (command != null)
    {
      if (!(command instanceof ToggleCommand))
        throw new IllegalArgumentException("Not ToggleCommand!");
      
      setSelected( ((ToggleCommand)command).isSelected() );
    }
    super.setCommand(command, useLabel, useIcon);
  }

  /**
   * When a toggle button is pressed, it toggles
   * its current selection state.
   */
  public void doInvokeAction(CommandEvent event)
  {
    setSelected( !getSelected() );
    super.doInvokeAction(event);
  }
  
  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    if (prop == selected)
    {
      boolean sel = getSelected();
      if (command != null && ((ToggleCommand)command).isSelected() != sel)
      {
        ((ToggleCommand)command).setSelected(sel);
        command.invoke();
      }
      StyleUtils.toggleStyleClass(this, "selected", this.isSelected());
    }
  }

  /**
   * Package protected theme access.
   */
  AbstractButtonTheme buttonTheme() { return Theme.toggleButton(); }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/toggleButton.png");
    
}
