/*
* Copyright 2000 Tridium, Inc. All Rights Reserved.
*/
package javax.baja.ui;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.event.*;
import com.tridium.ui.theme.*;

/**
* BSpinnerButton
*
* @author    Mike Jarmy
* @creation  26 Mar 01
* @version   $Revision: 29$ $Date: 6/30/11 5:11:34 PM EDT$
* @since     Baja 1.0
*/
public class BSpinnerButton
  extends BWidget
{

/*-

  class BSpinnerButton
  {
    actions
    {
      handleUpMouseEvent(arg: BMouseEvent)
        default {[ new BMouseEvent() ]}
      handleDownMouseEvent(arg: BMouseEvent)
        default {[ new BMouseEvent() ]}
    }

    topics
    {
      increment: BWidgetEvent
      decrement: BWidgetEvent
    }
  }

-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BSpinnerButton(1121907557)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "handleUpMouseEvent"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>handleUpMouseEvent</code> action.
   * @see javax.baja.ui.BSpinnerButton#handleUpMouseEvent()
   */
  public static final Action handleUpMouseEvent = newAction(0,new BMouseEvent(),null);
  
  /**
   * Invoke the <code>handleUpMouseEvent</code> action.
   * @see javax.baja.ui.BSpinnerButton#handleUpMouseEvent
   */
  public void handleUpMouseEvent(BMouseEvent arg) { invoke(handleUpMouseEvent,arg,null); }

////////////////////////////////////////////////////////////////
// Action "handleDownMouseEvent"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>handleDownMouseEvent</code> action.
   * @see javax.baja.ui.BSpinnerButton#handleDownMouseEvent()
   */
  public static final Action handleDownMouseEvent = newAction(0,new BMouseEvent(),null);
  
  /**
   * Invoke the <code>handleDownMouseEvent</code> action.
   * @see javax.baja.ui.BSpinnerButton#handleDownMouseEvent
   */
  public void handleDownMouseEvent(BMouseEvent arg) { invoke(handleDownMouseEvent,arg,null); }

////////////////////////////////////////////////////////////////
// Topic "increment"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>increment</code> topic.
   * @see javax.baja.ui.BSpinnerButton#fireIncrement
   */
  public static final Topic increment = newTopic(0,null);
  
  /**
   * Fire an event for the <code>increment</code> topic.
   * @see javax.baja.ui.BSpinnerButton#increment
   */
  public void fireIncrement(BWidgetEvent event) { fire(increment, event, null); }

////////////////////////////////////////////////////////////////
// Topic "decrement"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>decrement</code> topic.
   * @see javax.baja.ui.BSpinnerButton#fireDecrement
   */
  public static final Topic decrement = newTopic(0,null);
  
  /**
   * Fire an event for the <code>decrement</code> topic.
   * @see javax.baja.ui.BSpinnerButton#decrement
   */
  public void fireDecrement(BWidgetEvent event) { fire(decrement, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSpinnerButton.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor.
   */
  public BSpinnerButton()
  {
    up = new BButton(); 
    up.setFocusTraversable(false);
    add("up", up);
    
    down = new BButton(); 
    down.setFocusTraversable(false);
    add("down", down);
    
    linkTo(up, BButton.mouseEvent, handleUpMouseEvent);
    linkTo(down, BButton.mouseEvent, handleDownMouseEvent);
  }
  
////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////


  /**
   * Handle a mouse up event.
   */
  public void doHandleUpMouseEvent(BMouseEvent event)
  {
    switch (event.getId())
    {
      case BMouseEvent.MOUSE_ENTERED:
        mUpInside = true;
        break;
      case BMouseEvent.MOUSE_EXITED:
        mUpInside = false;
        lastDownPulse = 0L; 
        break;
      case BMouseEvent.MOUSE_PRESSED:
        mUpPressed = true;
        break;
      case BMouseEvent.MOUSE_RELEASED:
        mUpPressed = false;
        lastUpPulse = 0L; 
        break;
      case BMouseEvent.MOUSE_PULSED:
        if (mUpInside)
        {
          long now = Clock.ticks();
          if ((now - lastUpPulse) > MIN_PULSE_ELAPSED)
          {
            fireIncrement(event);
            lastUpPulse = now;
          }
        }
        break;
    }
  }

  /**
   * Handle a mouse down event.
   */
  public void doHandleDownMouseEvent(BMouseEvent event)
  {
    switch (event.getId())
    {
      case BMouseEvent.MOUSE_ENTERED:
        mDownInside = true;
        break;
      case BMouseEvent.MOUSE_EXITED:
        mDownInside = false;
        lastDownPulse = 0L; 
        break;
      case BMouseEvent.MOUSE_PRESSED:
        mDownPressed = true;
        break;
      case BMouseEvent.MOUSE_RELEASED:
        mDownPressed = false;
        lastDownPulse = 0L; 
        break;
      case BMouseEvent.MOUSE_PULSED:
        if (mDownInside)
        {
          long now = Clock.ticks();
          if ((now - lastDownPulse) > MIN_PULSE_ELAPSED)
          {
            fireDecrement(event);
            lastDownPulse = now;
          }
        }
        break;
    }
  }

////////////////////////////////////////////////////////////////
// paint
////////////////////////////////////////////////////////////////

  /**
   * Paint.
   */
  public void paint(Graphics g)
  {
    SpinnerButtonTheme theme = Theme.spinner();

    double w = getWidth();
    double h = getHeight();

    g.setBrush(theme.getControlShadow(this));
    g.strokeLine(0, 0, w-1, 0);
    g.strokeLine(0, 0, 0, h-1);

    g.setBrush(theme.getControlHighlight(this));
    g.strokeLine(w-1, 1, w-1, h-1);
    g.strokeLine(1, h-1, w-1, h-1);

    // paint children
    paintChild(g, up);
    paintChild(g, down);

    // set arrow brush
    BBrush fg = theme.getControlForeground(this);
    g.setBrush(fg);

    theme.paintArrows(g, up, down,
      (mUpInside && mUpPressed), (mDownInside && mDownPressed));
  }
  
  public String getStyleSelector() { return "button spinner"; }

////////////////////////////////////////////////////////////////
// layout
////////////////////////////////////////////////////////////////

  public void computePreferredSize()
  {
    setPreferredSize(getWidth(),getHeight());
  }

  /*
  *
  */
  public void doLayout(BWidget[] children)
  {
    double width = getWidth();
    double height = getHeight();
    double buttonHeight;
    double buttonWidth;
    if(Theme.spinner().isStacked())
    {
      buttonHeight = height / 2;
      buttonWidth = width - 2;
      up.setBounds(1, 1, buttonWidth, buttonHeight);
      down.setBounds(1, buttonHeight, buttonWidth, buttonHeight);
    }
    else
    {
      buttonHeight = height - 2;
      buttonWidth = width / 2;
      up.setBounds(1, 1, buttonWidth, buttonHeight);
      down.setBounds(buttonWidth, 1, buttonWidth, buttonHeight);
    }
  }

////////////////////////////////////////////////////////////////
// attributes
////////////////////////////////////////////////////////////////

  BButton up;
  BButton down;
  boolean mUpInside = false;
  boolean mUpPressed = false;
  boolean mDownInside = false;
  boolean mDownPressed = false;
  
  long lastDownPulse = 0L;
  long lastUpPulse = 0L;
  
  static final long MIN_PULSE_ELAPSED = 250;
}
