/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.enums.*;
import com.tridium.ui.theme.*;

/**
 * BSeparator is used in BToolBars and BMenu's to 
 * provide a visible separator between groups of
 * buttons.
 *
 * @author    Brian Frank       
 * @creation  4 Jan 01
 * @version   $Revision: 18$ $Date: 7/1/11 5:32:16 PM EDT$
 * @since     Baja 1.0
 */
public class BSeparator
  extends BWidget
{ 

  /*-    
  
  class BSeparator
  {
    properties
    {
      orientation: BOrientation
        -- Orientation defines whether the separator is 
        -- horizontal or vertical.
        default {[ BOrientation.horizontal ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BSeparator(3741361723)1.0$ @*/
/* Generated Sat Dec 17 22:53:02 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "orientation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>orientation</code> property.
   * Orientation defines whether the separator is horizonal
   * or vertical.
   * @see javax.baja.ui.BSeparator#getOrientation
   * @see javax.baja.ui.BSeparator#setOrientation
   */
  public static final Property orientation = newProperty(0, BOrientation.horizontal,null);
  
  /**
   * Get the <code>orientation</code> property.
   * Orientation defines whether the separator is horizonal
   * or vertical.
   * @see javax.baja.ui.BSeparator#orientation
   */
  public BOrientation getOrientation() { return (BOrientation)get(orientation); }
  
  /**
   * Set the <code>orientation</code> property.
   * Orientation defines whether the separator is horizonal
   * or vertical.
   * @see javax.baja.ui.BSeparator#orientation
   */
  public void setOrientation(BOrientation v) { set(orientation,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSeparator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Separator constructor with orientation.
   */
  public BSeparator(BOrientation orientation)
  {
    setOrientation(orientation);
  }

  /**
   * No arg constructor.
   */
  public BSeparator()
  {
  }

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  /**
   * Separators do not receive input events.  
   */
  public boolean receiveInputEvents()
  {
    return false;
  }

  /**
   * Compute the menu bar's preferred size.
   */
  public void computePreferredSize()
  {
    double w = Theme.separator().getFixedWidth(this);
    setPreferredSize(w, w);
  }
  
  /**
   * Paint the menu bar.
   */ 
  public void paint(Graphics g)
  {
    Theme.separator().paintSeparator(g, this);
  }
  
  public String getStyleSelector() { return "separator"; }
  
///////////////////////////////////////////////////////////
// Overrides
/////////////////////////////////////////////////////////// 

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/separator.png");
  
}
