/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.sys.*;
import javax.baja.ui.enums.*;
import javax.baja.ui.event.*;
import com.tridium.ui.theme.*;

/**
 * BRadioButton is a specialized BToggleButton which
 * displays its label next to a circle which can be
 * checked and unchecked.  It is used with groups of
 * other BRadioButton's to provide an choice which is
 * exclusive of other options.
 *
 * @author    Brian Frank       
 * @creation  7 Dec 00
 * @version   $Revision: 21$ $Date: 6/28/11 1:23:39 PM EDT$
 * @since     Baja 1.0
 */
public class BRadioButton
  extends BToggleButton
{
////////////////////////////////////////////////////////////////
// Properties
////////////////////////////////////////////////////////////////
  
  public static final Property halign = newProperty(0, BHalign.left);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRadioButton.class);

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Construct a radio button with the specified label text.
   */
  public BRadioButton(String text)
  {
    setText(text);
  }

  /**
   * Construct a radio button with the specified label 
   * text and selection state.
   */
  public BRadioButton(String text, boolean selected)
  {
    setText(text);
    setSelected(selected);
  }

  /**
   * Create radio button with a command.
   */
  public BRadioButton(ToggleCommand cmd, boolean useLabel, boolean useIcon)
  {
    super(cmd, useLabel, useIcon);  
  }

  /**
   * Create radio button with a command with label, but not icon.
   */
  public BRadioButton(ToggleCommand cmd)
  {
    super(cmd, true, false);  
  }

  /**
   * Convenience for <code>this(group, text, false)</code>.
   */
  @SuppressWarnings("rawtypes")
  public BRadioButton(ToggleCommandGroup group, String text)
  {
    this(group, text, false);  
  }

  /**
   * Create a radio button which is automatically in the specified 
   * group.  A toggle command is automatically created and registered 
   * into the group for this widget.
   */
  @SuppressWarnings({"rawtypes", "unchecked"})
  public BRadioButton(ToggleCommandGroup group, String text, boolean selected)
  {
    this(text, selected);
    ToggleCommand cmd = new ToggleCommand(this, text);
    setCommand(cmd, false, false);
    group.add(cmd);
  }

  /**
   * No argument constructor.
   */
  public BRadioButton()
  {
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  public void mousePressed(BMouseEvent event)
  {
    super.mousePressed(event);
    requestFocus();
  }

  /**
   * Package protected theme access.
   */
  AbstractButtonTheme buttonTheme() { return Theme.radioButton(); }    

  public String getStyleSelector() { return "button radio"; }
  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("widgets/radioButton.png");
  
}
