/*
* Copyright 2000 Tridium, Inc. All Rights Reserved.
*/
package javax.baja.ui;

import java.text.*;
import javax.baja.sys.*;
import javax.baja.gx.*;
import javax.baja.ui.event.*;
import com.tridium.ui.theme.*;

/**
* BProgressBar
*
* @author    Mike Jarmy
* @creation  11 Apr 02
* @version   $Revision: 22$ $Date: 11/22/06 4:14:10 PM EST$
* @since     Baja 1.0
*/
public class BProgressBar
  extends BWidget
{                    

////////////////////////////////////////////////////////////////
// frozen slots
////////////////////////////////////////////////////////////////

  /*-
  class BProgressBar
  {
    properties
    {
      min: double
        -- Minimum value of progress bar.
        default {[ 0 ]}
      max: double
        -- Maximum value of progress bar.
        default {[ 100 ]}
      textPattern: String
        -- A string which will be used via
        -- <code>java.text.DecimalFormat.format()</code> to render 
        -- the current value of <code>getPercentComplete()</code> onto 
        -- the progress bar. 
        -- If the textPattern is null or "", then no string will be rendered.
        default {[ "#%" ]}
      textFont: BFont
        -- Defines the font to use to render the progress bars's
        -- text.  If it is set to BFont.NULL then a context 
        -- sensitive default fallback will be used.
        default {[ BFont.NULL ]}        
      backgroundBrush: BBrush
        default {[ BColor.white.toBrush() ]}
      barBrush: BBrush
        default {[ BColor.gray.toBrush() ]}
      indeterminate: boolean
        -- Define if this bar's progress is indeterminate.
        default {[ false ]}
    }
    topics
    {
      valueChanged: BWidgetEvent
        -- Fired each time the progress bar's value is changed.
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BProgressBar(876669268)1.0$ @*/
/* Generated Sat Dec 17 22:53:01 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * Minimum value of progress bar.
   * @see javax.baja.ui.BProgressBar#getMin
   * @see javax.baja.ui.BProgressBar#setMin
   */
  public static final Property min = newProperty(0, 0,null);
  
  /**
   * Get the <code>min</code> property.
   * Minimum value of progress bar.
   * @see javax.baja.ui.BProgressBar#min
   */
  public double getMin() { return getDouble(min); }
  
  /**
   * Set the <code>min</code> property.
   * Minimum value of progress bar.
   * @see javax.baja.ui.BProgressBar#min
   */
  public void setMin(double v) { setDouble(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * Maximum value of progress bar.
   * @see javax.baja.ui.BProgressBar#getMax
   * @see javax.baja.ui.BProgressBar#setMax
   */
  public static final Property max = newProperty(0, 100,null);
  
  /**
   * Get the <code>max</code> property.
   * Maximum value of progress bar.
   * @see javax.baja.ui.BProgressBar#max
   */
  public double getMax() { return getDouble(max); }
  
  /**
   * Set the <code>max</code> property.
   * Maximum value of progress bar.
   * @see javax.baja.ui.BProgressBar#max
   */
  public void setMax(double v) { setDouble(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "textPattern"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>textPattern</code> property.
   * A string which will be used via <code>java.text.DecimalFormat.format()</code>
   * to render the current value of <code>getPercentComplete()</code>
   * onto the progress bar. If the textPattern is null or "", then no string will be rendered.
   * @see javax.baja.ui.BProgressBar#getTextPattern
   * @see javax.baja.ui.BProgressBar#setTextPattern
   */
  public static final Property textPattern = newProperty(0, "#%",null);
  
  /**
   * Get the <code>textPattern</code> property.
   * A string which will be used via <code>java.text.DecimalFormat.format()</code>
   * to render the current value of <code>getPercentComplete()</code>
   * onto the progress bar. If the textPattern is null or "", then no string will be rendered.
   * @see javax.baja.ui.BProgressBar#textPattern
   */
  public String getTextPattern() { return getString(textPattern); }
  
  /**
   * Set the <code>textPattern</code> property.
   * A string which will be used via <code>java.text.DecimalFormat.format()</code>
   * to render the current value of <code>getPercentComplete()</code>
   * onto the progress bar. If the textPattern is null or "", then no string will be rendered.
   * @see javax.baja.ui.BProgressBar#textPattern
   */
  public void setTextPattern(String v) { setString(textPattern,v,null); }

////////////////////////////////////////////////////////////////
// Property "textFont"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>textFont</code> property.
   * Defines the font to use to render the progress bars's
   * text.  If it is set to BFont.NULL then a context sensitive
   * default fallback will be used.
   * @see javax.baja.ui.BProgressBar#getTextFont
   * @see javax.baja.ui.BProgressBar#setTextFont
   */
  public static final Property textFont = newProperty(0, BFont.NULL,null);
  
  /**
   * Get the <code>textFont</code> property.
   * Defines the font to use to render the progress bars's
   * text.  If it is set to BFont.NULL then a context sensitive
   * default fallback will be used.
   * @see javax.baja.ui.BProgressBar#textFont
   */
  public BFont getTextFont() { return (BFont)get(textFont); }
  
  /**
   * Set the <code>textFont</code> property.
   * Defines the font to use to render the progress bars's
   * text.  If it is set to BFont.NULL then a context sensitive
   * default fallback will be used.
   * @see javax.baja.ui.BProgressBar#textFont
   */
  public void setTextFont(BFont v) { set(textFont,v,null); }

////////////////////////////////////////////////////////////////
// Property "backgroundBrush"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>backgroundBrush</code> property.
   * @see javax.baja.ui.BProgressBar#getBackgroundBrush
   * @see javax.baja.ui.BProgressBar#setBackgroundBrush
   */
  public static final Property backgroundBrush = newProperty(0, BColor.white.toBrush(),null);
  
  /**
   * Get the <code>backgroundBrush</code> property.
   * @see javax.baja.ui.BProgressBar#backgroundBrush
   */
  public BBrush getBackgroundBrush() { return (BBrush)get(backgroundBrush); }
  
  /**
   * Set the <code>backgroundBrush</code> property.
   * @see javax.baja.ui.BProgressBar#backgroundBrush
   */
  public void setBackgroundBrush(BBrush v) { set(backgroundBrush,v,null); }

////////////////////////////////////////////////////////////////
// Property "barBrush"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>barBrush</code> property.
   * @see javax.baja.ui.BProgressBar#getBarBrush
   * @see javax.baja.ui.BProgressBar#setBarBrush
   */
  public static final Property barBrush = newProperty(0, BColor.gray.toBrush(),null);
  
  /**
   * Get the <code>barBrush</code> property.
   * @see javax.baja.ui.BProgressBar#barBrush
   */
  public BBrush getBarBrush() { return (BBrush)get(barBrush); }
  
  /**
   * Set the <code>barBrush</code> property.
   * @see javax.baja.ui.BProgressBar#barBrush
   */
  public void setBarBrush(BBrush v) { set(barBrush,v,null); }

////////////////////////////////////////////////////////////////
// Property "indeterminate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>indeterminate</code> property.
   * Define if this bar's progress is indeterminate.
   * @see javax.baja.ui.BProgressBar#getIndeterminate
   * @see javax.baja.ui.BProgressBar#setIndeterminate
   */
  public static final Property indeterminate = newProperty(0, false,null);
  
  /**
   * Get the <code>indeterminate</code> property.
   * Define if this bar's progress is indeterminate.
   * @see javax.baja.ui.BProgressBar#indeterminate
   */
  public boolean getIndeterminate() { return getBoolean(indeterminate); }
  
  /**
   * Set the <code>indeterminate</code> property.
   * Define if this bar's progress is indeterminate.
   * @see javax.baja.ui.BProgressBar#indeterminate
   */
  public void setIndeterminate(boolean v) { setBoolean(indeterminate,v,null); }

////////////////////////////////////////////////////////////////
// Topic "valueChanged"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueChanged</code> topic.
   * Fired each time the progress bar's value is changed.
   * @see javax.baja.ui.BProgressBar#fireValueChanged
   */
  public static final Topic valueChanged = newTopic(0,null);
  
  /**
   * Fire an event for the <code>valueChanged</code> topic.
   * Fired each time the progress bar's value is changed.
   * @see javax.baja.ui.BProgressBar#valueChanged
   */
  public void fireValueChanged(BWidgetEvent event) { fire(valueChanged, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BProgressBar.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// constructors
////////////////////////////////////////////////////////////////  

  /**
  * default constructor
  */
  public BProgressBar()
  {                      
  }
  
  /**
  * construct with minimum and maximum
  */
  public BProgressBar(double min, double max)
  {
    this();
    setMin(min);
    setMax(max);
  }
  
////////////////////////////////////////////////////////////////
// Layout
////////////////////////////////////////////////////////////////  

  /**
   * Compute the preferred size.
   */
  public void computePreferredSize()
  { 
    setPreferredSize(200, 20);
  }
  
////////////////////////////////////////////////////////////////
// paint
////////////////////////////////////////////////////////////////  
  
  /**
   * Animate.
   */
  public void animate()
  {
    if (getIndeterminate()) 
    {
      inOff += 4;
      if (inOff >= 16) inOff = 0;
      repaint();
    }
  }

  /**
   * Paint the label.
   */
  public void paint(Graphics g)
  {    
    double w = getWidth();
    double h = getHeight();
    int pw = 0;
    
    BBrush bg = getBackgroundBrush();
    BBrush fg = getBarBrush();
    
    // background
    g.setBrush(bg);
    g.fillRect(0, 0, w, h);

    if (getIndeterminate())
    {
      // draw stripes
      g.setBrush(fg);
      for (int i=-(int)(h+16); i<w; i+=16)      
      {        
        int x = i + inOff;
        
        g.strokeLine(x,   h, x+h,   0);
        g.strokeLine(x+1, h, x+h+1, 0);
        g.strokeLine(x+2, h, x+h+2, 0);
        g.strokeLine(x+3, h, x+h+3, 0);
        g.strokeLine(x+4, h, x+h+4, 0);
        g.strokeLine(x+5, h, x+h+5, 0);
        g.strokeLine(x+6, h, x+h+6, 0);
        g.strokeLine(x+7, h, x+h+7, 0);
        g.strokeLine(x+8, h, x+h+8, 0);
      }
    }
    else
    {
      // draw the bar
      pw = (int) (getPercentComplete() * w);    
      g.setBrush(fg);
      g.fillRect(0, 0, pw, h);    
    }
    
    // outline
    g.setBrush(BColor.black);
    g.strokeRect(0, 0, w-1, h-1);

    if (getIndeterminate()) return;

    String pattern = getTextPattern();
    if (!pattern.equals(""))
    {    
      // get the string
      DecimalFormat df = new DecimalFormat(pattern);
      String text = df.format(getPercentComplete());
      
      // get measurements
      BFont font = getTextFont();
      if (font.isNull()) font = Theme.label().getTextFont();
      g.setFont(font);

      double fontHeight = font.getHeight();
      double fontDescent = font.getDescent();
      double textWidth = font.width(text);

      double tx = (w - textWidth)/2;
      double ty = (h - fontHeight)/2;

      // draw 
      g.push();
      try
      {
        g.clip(0, 0, pw, h);
        g.setBrush(bg);
        g.drawString(text, tx, ty + fontHeight - fontDescent);
      }
      finally 
      {
        g.pop(); 
      }
      
      g.push();
      try
      {
        g.clip(pw, 0, w-pw, h);
        g.setBrush(fg);
        g.drawString(text, tx, ty + fontHeight - fontDescent);
      }
      finally 
      { 
        g.pop(); 
      }
    }
  }

////////////////////////////////////////////////////////////////
// public
////////////////////////////////////////////////////////////////  

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Get the current value of progress bar.
   */
  public double getValue() { return value; }
  
  /**
   * Set the current value of progress bar. If this value is set
   * lower than the minimum value, it will be changed to
   * the minimum value instead. If this value
   * is set higher than the maximum value, it will be changed
   * to the maximum value.
   */
  public void setValue(double v) 
  { 
    if (v < getMin()) v = getMin();
    else if (v > getMax()) v = getMax();
    
    value = v;
    fireValueChanged(null);
    repaint();
  }

  /**
  * Get the percent complete.
  */
  public double getPercentComplete()
  {
    return 
      (getValue() - getMin())/
      (getMax() - getMin());
  }

////////////////////////////////////////////////////////////////
// attributes
////////////////////////////////////////////////////////////////  

  private double value;
  private int inOff = 0;

}
