/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.ui;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.ui.event.*;

/**
 * BHyperlinkLabel is a label which performs a hyperlink
 * when clicked.  It automatically changes the mouse
 * cursor to the standard link cursor. 
 *
 * @author    Brian Frank       
 * @creation  29 Sep 04
 * @version   $Revision: 3$ $Date: 8/30/07 2:17:31 PM EDT$
 * @since     Baja 1.0
 */
public class BHyperlinkLabel
  extends BLabel
{                      

  /*-
  class BHyperlinkLabel
  {
    properties
    {
      ord: BOrd
        -- The ord to hyperlink.
        default {[ BOrd.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.ui.BHyperlinkLabel(737085243)1.0$ @*/
/* Generated Sat Dec 17 22:53:01 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ord"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ord</code> property.
   * The ord to hyperlink.
   * @see javax.baja.ui.BHyperlinkLabel#getOrd
   * @see javax.baja.ui.BHyperlinkLabel#setOrd
   */
  public static final Property ord = newProperty(0, BOrd.NULL,null);
  
  /**
   * Get the <code>ord</code> property.
   * The ord to hyperlink.
   * @see javax.baja.ui.BHyperlinkLabel#ord
   */
  public BOrd getOrd() { return (BOrd)get(ord); }
  
  /**
   * Set the <code>ord</code> property.
   * The ord to hyperlink.
   * @see javax.baja.ui.BHyperlinkLabel#ord
   */
  public void setOrd(BOrd v) { set(ord,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHyperlinkLabel.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BHyperlinkLabel()
  {
  }
  
  public BHyperlinkLabel(String label, BOrd ord)
  {
    super(label);
    setOrd(ord);
  }

////////////////////////////////////////////////////////////////
// State
////////////////////////////////////////////////////////////////
    
  /**
   * Return true if the mouse is currently over the button.
   */
  public boolean isMouseOver()
  {
    return mouseOver;
  }
          
////////////////////////////////////////////////////////////////
// Eventing
////////////////////////////////////////////////////////////////  
  
  /**
   * Return true.
   */
  public boolean receiveInputEvents()
  {
    return true;
  }  
    
  /**
   * Handle mousePressed event.
   */
  public void mousePressed(BMouseEvent event) 
  {                             
    BWidgetShell shell = getShell();
    BOrd ord = getOrd();
    
    if (mouseOver && !ord.isNull() && shell instanceof BIHyperlinkShell)
      ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, event));
  }
    
  /**
   * Handle mouseEntered event.
   */
  public void mouseEntered(BMouseEvent event) 
  {
    BWidgetShell shell = getShell();
    BOrd ord = getOrd();
    
    if (shell != null && !ord.isNull()) 
    {
      shell.showStatus(ord.toString());      
      setMouseCursor(MouseCursor.hand);
    }
      
    mouseOver = true;
  }
  
  /**
   * Handle mouseExited event.
   */
  public void mouseExited(BMouseEvent event) 
  {
    BWidgetShell shell = getShell();
    if (shell != null) shell.showStatus(null);
    
    mouseOver = false;
    setMouseCursor(MouseCursor.normal);
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return getImage().isNull()?icon:imageIcon; }
  private static final BIcon icon = BIcon.std("widgets/hyperlinkLabel.png");
  private static final BIcon imageIcon = BIcon.std("widgets/image.png");
              
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private boolean mouseOver = false;
  
}

