/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;

/**
 * BWsTextBlock is a Niagara specific component used to visualize
 * text blocks on a WireSheet.
 *
 * @author    Brian Frank
 * @creation  29 Oct 03
 * @version   $Revision: 5$ $Date: 2/4/08 10:12:28 AM EST$
 * @since     Baja 1.0
 */
public class BWsTextBlock
  extends BComponent
{                                                      
  /*-
  
  class BWsTextBlock
  {       
    properties
    {             
      text: String
        -- The text to display in the block      
        default {[ "" ]}
        slotfacets {[ BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE) ]}
      foreground: String
        -- String encoding of foreground color (see gx:Color)
        default {[ "#ff000000" ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, "wbutil:ColorFE") ]}
      background: String
        -- String encoding of background color (see gx:Color)
        default {[ "#00000000" ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, "wbutil:ColorFE") ]}
      font: String
        -- String encoding of text font (see gx:Font)
        default {[ "12pt Arial" ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, "workbench:FontFE") ]}
      border: boolean
        -- Specified whether a border should be drawn using foreground color.
        default {[ false ]}     
      selectable: boolean
        -- Allows the block to be selectable or unselectable on wire sheet.
        default {[ true ]}     
      wsAnnotation: BWsAnnotation
        -- Positioning on the wiresheet.
        flags { readonly }
        default {[ BWsAnnotation.make(1, 1, 20, 2) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BWsTextBlock(1424956702)1.0$ @*/
/* Generated Sat Dec 17 22:42:37 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "text"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>text</code> property.
   * The text to display in the block
   * @see javax.baja.util.BWsTextBlock#getText
   * @see javax.baja.util.BWsTextBlock#setText
   */
  public static final Property text = newProperty(0, "",BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE));
  
  /**
   * Get the <code>text</code> property.
   * The text to display in the block
   * @see javax.baja.util.BWsTextBlock#text
   */
  public String getText() { return getString(text); }
  
  /**
   * Set the <code>text</code> property.
   * The text to display in the block
   * @see javax.baja.util.BWsTextBlock#text
   */
  public void setText(String v) { setString(text,v,null); }

////////////////////////////////////////////////////////////////
// Property "foreground"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>foreground</code> property.
   * String encoding of foreground color (see gx:Color)
   * @see javax.baja.util.BWsTextBlock#getForeground
   * @see javax.baja.util.BWsTextBlock#setForeground
   */
  public static final Property foreground = newProperty(0, "#ff000000",BFacets.make(BFacets.FIELD_EDITOR, "wbutil:ColorFE"));
  
  /**
   * Get the <code>foreground</code> property.
   * String encoding of foreground color (see gx:Color)
   * @see javax.baja.util.BWsTextBlock#foreground
   */
  public String getForeground() { return getString(foreground); }
  
  /**
   * Set the <code>foreground</code> property.
   * String encoding of foreground color (see gx:Color)
   * @see javax.baja.util.BWsTextBlock#foreground
   */
  public void setForeground(String v) { setString(foreground,v,null); }

////////////////////////////////////////////////////////////////
// Property "background"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>background</code> property.
   * String encoding of background color (see gx:Color)
   * @see javax.baja.util.BWsTextBlock#getBackground
   * @see javax.baja.util.BWsTextBlock#setBackground
   */
  public static final Property background = newProperty(0, "#00000000",BFacets.make(BFacets.FIELD_EDITOR, "wbutil:ColorFE"));
  
  /**
   * Get the <code>background</code> property.
   * String encoding of background color (see gx:Color)
   * @see javax.baja.util.BWsTextBlock#background
   */
  public String getBackground() { return getString(background); }
  
  /**
   * Set the <code>background</code> property.
   * String encoding of background color (see gx:Color)
   * @see javax.baja.util.BWsTextBlock#background
   */
  public void setBackground(String v) { setString(background,v,null); }

////////////////////////////////////////////////////////////////
// Property "font"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>font</code> property.
   * String encoding of text font (see gx:Font)
   * @see javax.baja.util.BWsTextBlock#getFont
   * @see javax.baja.util.BWsTextBlock#setFont
   */
  public static final Property font = newProperty(0, "12pt Arial",BFacets.make(BFacets.FIELD_EDITOR, "workbench:FontFE"));
  
  /**
   * Get the <code>font</code> property.
   * String encoding of text font (see gx:Font)
   * @see javax.baja.util.BWsTextBlock#font
   */
  public String getFont() { return getString(font); }
  
  /**
   * Set the <code>font</code> property.
   * String encoding of text font (see gx:Font)
   * @see javax.baja.util.BWsTextBlock#font
   */
  public void setFont(String v) { setString(font,v,null); }

////////////////////////////////////////////////////////////////
// Property "border"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>border</code> property.
   * Specified whether a border should be drawn using foreground
   * color.
   * @see javax.baja.util.BWsTextBlock#getBorder
   * @see javax.baja.util.BWsTextBlock#setBorder
   */
  public static final Property border = newProperty(0, false,null);
  
  /**
   * Get the <code>border</code> property.
   * Specified whether a border should be drawn using foreground
   * color.
   * @see javax.baja.util.BWsTextBlock#border
   */
  public boolean getBorder() { return getBoolean(border); }
  
  /**
   * Set the <code>border</code> property.
   * Specified whether a border should be drawn using foreground
   * color.
   * @see javax.baja.util.BWsTextBlock#border
   */
  public void setBorder(boolean v) { setBoolean(border,v,null); }

////////////////////////////////////////////////////////////////
// Property "selectable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>selectable</code> property.
   * Allows the block to be selectable or unselectable on wire sheet.
   * @see javax.baja.util.BWsTextBlock#getSelectable
   * @see javax.baja.util.BWsTextBlock#setSelectable
   */
  public static final Property selectable = newProperty(0, true,null);
  
  /**
   * Get the <code>selectable</code> property.
   * Allows the block to be selectable or unselectable on wire sheet.
   * @see javax.baja.util.BWsTextBlock#selectable
   */
  public boolean getSelectable() { return getBoolean(selectable); }
  
  /**
   * Set the <code>selectable</code> property.
   * Allows the block to be selectable or unselectable on wire sheet.
   * @see javax.baja.util.BWsTextBlock#selectable
   */
  public void setSelectable(boolean v) { setBoolean(selectable,v,null); }

////////////////////////////////////////////////////////////////
// Property "wsAnnotation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>wsAnnotation</code> property.
   * Positioning on the wiresheet.
   * @see javax.baja.util.BWsTextBlock#getWsAnnotation
   * @see javax.baja.util.BWsTextBlock#setWsAnnotation
   */
  public static final Property wsAnnotation = newProperty(Flags.READONLY, BWsAnnotation.make(1, 1, 20, 2),null);
  
  /**
   * Get the <code>wsAnnotation</code> property.
   * Positioning on the wiresheet.
   * @see javax.baja.util.BWsTextBlock#wsAnnotation
   */
  public BWsAnnotation getWsAnnotation() { return (BWsAnnotation)get(wsAnnotation); }
  
  /**
   * Set the <code>wsAnnotation</code> property.
   * Positioning on the wiresheet.
   * @see javax.baja.util.BWsTextBlock#wsAnnotation
   */
  public void setWsAnnotation(BWsAnnotation v) { set(wsAnnotation,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BWsTextBlock.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("text.png");  

}
