/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;
import javax.baja.spy.*;

/**
 * BWorker is a BComponent wrapper for Worker
 *
 * @author    Brian Frank
 * @creation  6 Feb 04
 * @version   $Revision: 2$ $Date: 8/25/04 8:47:34 AM EDT$
 * @since     Baja 1.0
 */
public abstract class BWorker
  extends BComponent
{                                                      
  /*-
  
  class BWorker
  {       
    properties
    {             
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BWorker(1908164141)1.0$ @*/
/* Generated Sat Feb 07 13:26:04 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BWorker.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  /**
   * If not isSteadyStateWorker() then call startWorker().
   */
  @Override
  public void started()
    throws Exception
  {
    super.started();  
    if (!isSteadyStateWorker()) startWorker();
  }

  /**
   * If isSteadyStateWorker() then call startWorker().
   */
  @Override
  public void atSteadyState()
    throws Exception
  {
    super.atSteadyState();
    if (isSteadyStateWorker()) startWorker();
  }
  
  /**
   * Call stopWorker().
   */
  @Override
  public void stopped()
    throws Exception
  {                
    super.stopped(); 
    stopWorker();
  }        
  
  /**
   * Get the Worker this BWorker wraps.
   */
  public abstract Worker getWorker(); 
  
  /**
   * Default implementation is <code>getWorker().start(toPathString())</code>.
   */
  protected void startWorker()
  {
    getWorker().start(getWorkerThreadName());
  }

  /**
   * Default implementation is <code>getWorker().stop()</code>.
   */
  protected void stopWorker()
  {              
    getWorker().stop();
  }
            
  /**
   * Return true if this worker doesn't start until steady
   * state is reached.  Return false to start immediately
   * on the <code>BComponent.started()</code> callback.  The 
   * default returns false.
   */
  protected boolean isSteadyStateWorker()
  {
    return false;
  }              
  
  /**
   * Get the thread name used to start the worker.
   */
  protected String getWorkerThreadName()
  {                                 
    return toPathString();
  }
  
////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  /**
   * Include worker's spy in diagnostics.
   */        
  @Override
  public void spy(SpyWriter out)
    throws Exception
  {
    Worker w = getWorker();
    if (w != null) w.spy(out);
    else { out.startProps("No Worker"); out.endProps(); }
    super.spy(out);
  }  

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("gears.png");     
  
}
