/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;

/**
 * BThreadPoolWorker is a BComponent wrapper for ThreadPoolWorker
 *
 * @author    Brian Frank
 * @creation  7 Feb 04
 * @version   $Revision: 3$ $Date: 8/23/06 2:42:43 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BThreadPoolWorker
  extends BWorker
{                                                      
  /*-
  
  class BThreadPoolWorker
  {       
    properties
    {         
      maxThreads: int  
        -- Max number of concurrent threads for working.
        default {[ 4 ]}    
        slotfacets {[BFacets.make(BFacets.MIN, BInteger.make(1))]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.util.BThreadPoolWorker(1769545676)1.0$ @*/
/* Generated Sat Dec 17 22:42:37 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "maxThreads"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxThreads</code> property.
   * Max number of concurrent threads for working.
   * @see javax.baja.util.BThreadPoolWorker#getMaxThreads
   * @see javax.baja.util.BThreadPoolWorker#setMaxThreads
   */
  public static final Property maxThreads = newProperty(0, 4,BFacets.make(BFacets.MIN, BInteger.make(1)));
  
  /**
   * Get the <code>maxThreads</code> property.
   * Max number of concurrent threads for working.
   * @see javax.baja.util.BThreadPoolWorker#maxThreads
   */
  public int getMaxThreads() { return getInt(maxThreads); }
  
  /**
   * Set the <code>maxThreads</code> property.
   * Max number of concurrent threads for working.
   * @see javax.baja.util.BThreadPoolWorker#maxThreads
   */
  public void setMaxThreads(int v) { setInt(maxThreads,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BThreadPoolWorker.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BThreadPoolWorker()
  {
  }

  public BThreadPoolWorker(int maxThreads)
  {                                      
    setMaxThreads(maxThreads);
  }                           
  
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  @Override
  public void started()
    throws Exception
  {
    super.started();
    updateMaxThreads();
  }

  @Override
  public void atSteadyState()
    throws Exception
  {
    super.atSteadyState();
    updateMaxThreads();
  }

  @Override
  public void changed(Property prop, Context cx)
  {     
    if (isRunning())
    {
      if (prop.equals(maxThreads)) { updateMaxThreads(); return; }
    }
    super.changed(prop, cx);
  }      
  
  void updateMaxThreads()
  {      
    ThreadPoolWorker w = (ThreadPoolWorker)getWorker();
    if (w != null) w.setMaxThreads(getMaxThreads());
  }

}
