/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.util;

import javax.baja.sys.*;


/**
 * The BNullConverter is used to represent no conversion.
 *
 * @author    Brian Frank
 * @creation  12 May 04
 * @version   $Revision: 2$ $Date: 5/19/04 4:24:20 PM EDT$
 * @since     Baja 1.0
 */
public class BNullConverter
  extends BConverter
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNullConverter.class);
    
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////
  
  /**
   * Return true.
   */
  @Override
  public boolean isNull()
  {
    return true;
  }     
  
  /**
   * Return the to object.
   */
  @Override
  public BObject convert(BObject from, BObject to, Context cx)
  {
    return to;
  }
  
}
