/*
 * Copyright 2007, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.user;

import javax.baja.sys.*;

/**
 * BUserEvent is fired when a user is added, removed, or modified.
 * 
 * @author    John Sublett
 * @creation  14 Aug 2007
 * @version   $Revision: 1$ $Date: 9/12/07 1:33:35 PM EDT$
 * @since     Baja 1.0
 */
public class BUserEvent
  extends BStruct
{

////////////////////////////////////////////////////////////////
// Ids
////////////////////////////////////////////////////////////////

  /** Unknown event id. */
  public static final int UNKNOWN  = -1;
  
  /** A user has been added. */
  public static final int ADDED    = 0;
  
  /** A user has been removed. */
  public static final int REMOVED  = 1;

  /** A user has been modified. */
  public static final int MODIFIED = 2;

  /** A user has been renamed. */
  public static final int RENAMED = 3;

////////////////////////////////////////////////////////////////
// Type def
////////////////////////////////////////////////////////////////

  /*-
  
  class BUserEvent
  {
    properties
    {
      id: int
        default {[ UNKNOWN ]}
      
      userName: String
        -- The name of the user was affected by the event.
        default {[ "" ]}
      
      oldName: String
        -- The old name for a rename event.  If the event is not a
        -- rename, then this property is unused.
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.user.BUserEvent(3003788042)1.0$ @*/
/* Generated Sat Dec 17 22:42:36 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>id</code> property.
   * @see javax.baja.user.BUserEvent#getId
   * @see javax.baja.user.BUserEvent#setId
   */
  public static final Property id = newProperty(0, UNKNOWN,null);
  
  /**
   * Get the <code>id</code> property.
   * @see javax.baja.user.BUserEvent#id
   */
  public int getId() { return getInt(id); }
  
  /**
   * Set the <code>id</code> property.
   * @see javax.baja.user.BUserEvent#id
   */
  public void setId(int v) { setInt(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "userName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>userName</code> property.
   * The name of the user was affected by the event.
   * @see javax.baja.user.BUserEvent#getUserName
   * @see javax.baja.user.BUserEvent#setUserName
   */
  public static final Property userName = newProperty(0, "",null);
  
  /**
   * Get the <code>userName</code> property.
   * The name of the user was affected by the event.
   * @see javax.baja.user.BUserEvent#userName
   */
  public String getUserName() { return getString(userName); }
  
  /**
   * Set the <code>userName</code> property.
   * The name of the user was affected by the event.
   * @see javax.baja.user.BUserEvent#userName
   */
  public void setUserName(String v) { setString(userName,v,null); }

////////////////////////////////////////////////////////////////
// Property "oldName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>oldName</code> property.
   * The old name for a rename event.  If the event is not a rename, then this property is unused.
   * @see javax.baja.user.BUserEvent#getOldName
   * @see javax.baja.user.BUserEvent#setOldName
   */
  public static final Property oldName = newProperty(0, "",null);
  
  /**
   * Get the <code>oldName</code> property.
   * The old name for a rename event.  If the event is not a rename, then this property is unused.
   * @see javax.baja.user.BUserEvent#oldName
   */
  public String getOldName() { return getString(oldName); }
  
  /**
   * Set the <code>oldName</code> property.
   * The old name for a rename event.  If the event is not a rename, then this property is unused.
   * @see javax.baja.user.BUserEvent#oldName
   */
  public void setOldName(String v) { setString(oldName,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUserEvent.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Factories
////////////////////////////////////////////////////////////////

  /**
   * Make an added event.
   */
  public static BUserEvent makeAdded(BUser user)
  {
    return new BUserEvent(ADDED, user);
  }
  
  /**
   * Make a removed event.
   *
   * @param user The user that was removed.
   * @param removedName The name of the user that was removed.
   *   This is necessary because the user is no longer mounted
   *   so the name is no longer available.
   */
  public static BUserEvent makeRemoved(BUser user, String removedName)
  {
    return new BUserEvent(REMOVED, user, removedName);
  }
  
  /**
   * Make a modified event.
   */
  public static BUserEvent makeModified(BUser user)
  {
    return new BUserEvent(MODIFIED, user);
  }

  /**
   * Make a renamed event.
   */
  public static BUserEvent makeRenamed(BUser user, String oldName)
  {
    BUserEvent e = new BUserEvent(RENAMED, user);
    e.setOldName(oldName);
    return e;
  }

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////


  public BUserEvent()
  {
  }

  public BUserEvent(int id, BUser user)
  {
    this(id, user, user.getName());
  }

  public BUserEvent(int id, BUser user, String userName)
  {
    setId(id);
    setUserName(userName);
    
    this.user = user;
  }

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Get the user for this event.  This is only available when
   * the event is received locally.
   */
  public BUser getUser()
  {
    return user;
  }

////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////

  /**
   * Get a string summary for this event.
   */
  public String toString(Context cx)
  {
    return idToString(getId()) + ": " + getUserName();
  }

  /**
   * Get a string for the specified id.
   */
  public static String idToString(int id)
  {
    switch (id)
    {
      case ADDED   : return "Added";
      case REMOVED : return "Removed";
      case MODIFIED: return "Modified";
      case RENAMED : return "Renamed";
      
      default:
        return "Unknown(" + id + ")";
    }
  }
  
////////////////////////////////////////////////////////////////
// Fields
////////////////////////////////////////////////////////////////

  private BUser    user;

}