/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * The BInterface is the super type of all Baja typed interfaces.
 * Only BObject classes can implement this interface and its
 * derived interfaces.  All BInterfaces must declare a public
 * static final called TYPE which loads the Type for the interface
 * class.
 *
 * @author    Brian Frank
 * @since     Baja 1.0
 */

public interface BInterface extends BIObject
{
  /**
   * Narrow to BObject.
   */
  BObject asObject();

  Type TYPE = Sys.loadType(BInterface.class);
}
