/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

import javax.baja.data.BIDataValue;

/**
 * BIObject is the super type of all Baja types in the Niagara Framework.
 *
 * @author <a href="mailto:mgiannini@tridium.com">Matthew Giannini</a>
 * @since Niagara 4.0
 */

public interface BIObject
{
  /**
   * Narrow to the given type.
   */
  <T extends BIObject> T as(Class<T> cls);

  /**
   * Get a BIDataValue instance for this instance.  If this type is
   * already a BIDataValue then this instance will be returned.
   * Otherwise, the returned instance will be the result of converting
   * this type into a BIDataValue.  Data types are defined in the
   * Baja Data API.
   */
  BIDataValue toDataValue();

  /**
   * Return a String version of the object based on the
   * specified context.  If context is null then a
   * non-localized debug String designed for engineering
   * use should be returned.  But if context is not null
   * then the object should return a localized String
   * designed for end user display.   The default
   * implementation routes to the various toXString()
   * methods.
   */
  String toString(Context context);

  /**
   * Equivalent is used to compare if two objects have equivalent
   * state, but might not want to return true for equals since it
   * it has implied semantics for many operations.  The default
   * implementation returns the result of {@code equals()}.
   */
  boolean equivalent(Object obj);

  /**
   * Get the type of this instance.  By convention this
   * type is stored in a public static final field named
   * {@code TYPE}.  It should be loaded only once
   * for a given class using the {@link Sys#loadType(Class)} method.
   */
  Type getType();

  Type TYPE = Sys.loadType(BIObject.class);
}
