/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * BINumeric is the interface implemented by BObjects 
 * which primarily represent a numeric value stored
 * as a double.
 *
 * @author    Brian Frank
 * @creation  28 Sept 00
 * @version   $Revision: 5$ $Date: 3/28/05 9:23:10 AM EST$
 * @since     Baja 1.0
 */
public interface BINumeric
  extends BInterface
{ 

  /**
   * Get the numeric as double value.
   */
  public double getNumeric();

  /**
   * Get facets for the numeric value or BFacets.NULL 
   * if not applicable.
   */
  public BFacets getNumericFacets();

  public static final Type TYPE = Sys.loadType(BINumeric.class);
  
}
