/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.sys;

/**
 * BIBoolean is the interface implemented by BObjects 
 * which primarily represent a boolean value.
 *
 * @author    Brian Frank
 * @creation  28 Sept 00
 * @version   $Revision: 4$ $Date: 3/28/05 9:23:10 AM EST$
 * @since     Baja 1.0
 */
public interface BIBoolean
  extends BIEnum
{ 

  /**
   * Get the boolean value.
   */
  public boolean getBoolean();
  
  /**
   * Get facets for the boolean value or BFacets.NULL 
   * if not applicable.
   */
  public BFacets getBooleanFacets();

  public static final Type TYPE = Sys.loadType(BIBoolean.class);
  
}
