/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.status;

import javax.baja.sys.*;

/**
 * BStatusNumeric defines a tuple representing a numeric value 
 * with a 64-bit double.
 *
 * @author    Dan Giorgis
 * @creation  15 Nov 00
 * @version   $Revision: 39$ $Date: 3/28/05 9:23:05 AM EST$
 * @since     Baja 1.0
 */
public class BStatusNumeric
  extends BStatusValue
  implements BINumeric
{ 

  /*-
  
  class BStatusNumeric
  {
    properties
    {
      value: double
        -- The value of a BStatusNumeric is a 64-bit primitive double.
        default {[ 0.0 ]}             
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.status.BStatusNumeric(3791140711)1.0$ @*/
/* Generated Sat Dec 17 22:42:36 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * The value of a BStatusNumeric is a 64-bit primitive
   * double.
   * @see javax.baja.status.BStatusNumeric#getValue
   * @see javax.baja.status.BStatusNumeric#setValue
   */
  public static final Property value = newProperty(0, 0.0,null);
  
  /**
   * Get the <code>value</code> property.
   * The value of a BStatusNumeric is a 64-bit primitive
   * double.
   * @see javax.baja.status.BStatusNumeric#value
   */
  public double getValue() { return getDouble(value); }
  
  /**
   * Set the <code>value</code> property.
   * The value of a BStatusNumeric is a 64-bit primitive
   * double.
   * @see javax.baja.status.BStatusNumeric#value
   */
  public void setValue(double v) { setDouble(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusNumeric.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with value and status.
   */
  public BStatusNumeric(double value, BStatus status) 
  { 
    super(status);
    setValue(value);
  }

  /**
   * Constructor with value.
   */
  public BStatusNumeric(double value) 
  { 
    setValue(value); 
  }

  /**
   * No argument constructor.
   */
  public BStatusNumeric() 
  {
  }

////////////////////////////////////////////////////////////////
// BINumeric
////////////////////////////////////////////////////////////////

  /**
   * Return <code>getValue()</code>.
   */
  public final double getNumeric()
  {
    return getValue();
  }

  /**
   * Return <code>BFacets.NULL</code>.
   */
  public final BFacets getNumericFacets()
  {
    return BFacets.NULL;
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////  

  /**
   * Get the value as a BValue.
   */
  public final BValue getValueValue()
  {
    return BDouble.make(getValue());
  }

  /**
   * Get the "value" property.
   */
  public final Property getValueProperty()
  {
    return value;
  }
  
  /**
   * Format the double value using:
   * <code>BDouble.toString(getValue(), Context)</code>.
   */
  public String valueToString(Context context)
  {
    return BDouble.toString(getValue(), context);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("statusNumeric.png");
  
}
