/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.status;

import javax.baja.sys.*;

/**
 * BStatusEnum is the normalized class for enumerated values.
 *
 * @author    Brian Frank
 * @creation  13 Dec 01
 * @version   $Revision: 23$ $Date: 10/19/10 4:52:14 PM EDT$
 * @since     Baja 1.0
 */
public class BStatusEnum
  extends BStatusValue
  implements BIEnum
{ 

  /*-
  
  class BStatusEnum
  {
    properties
    {
      value: BDynamicEnum
        -- The value of a BStatusEnum is stored in an BDynamicEnum.
        default {[ BDynamicEnum.DEFAULT ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.status.BStatusEnum(1554491828)1.0$ @*/
/* Generated Sat Dec 17 22:42:36 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * The value of a BStatusEnum is stored in an BDynamicEnum.
   * @see javax.baja.status.BStatusEnum#getValue
   * @see javax.baja.status.BStatusEnum#setValue
   */
  public static final Property value = newProperty(0, BDynamicEnum.DEFAULT,null);
  
  /**
   * Get the <code>value</code> property.
   * The value of a BStatusEnum is stored in an BDynamicEnum.
   * @see javax.baja.status.BStatusEnum#value
   */
  public BDynamicEnum getValue() { return (BDynamicEnum)get(value); }
  
  /**
   * Set the <code>value</code> property.
   * The value of a BStatusEnum is stored in an BDynamicEnum.
   * @see javax.baja.status.BStatusEnum#value
   */
  public void setValue(BDynamicEnum v) { set(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusEnum.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with value and status.
   */
  public BStatusEnum(BEnum value, BStatus status) 
  { 
    super(status);
    setValue(value);
  }

  /**
   * Constructor with value.
   */
  public BStatusEnum(BEnum value) 
  { 
    setValue(value); 
  }

  /**
   * No argument constructor.
   */
  public BStatusEnum() 
  { 
  }

////////////////////////////////////////////////////////////////
// BIEnum
////////////////////////////////////////////////////////////////

  /**
   * Return <code>getValue()</code>.
   */
  public BEnum getEnum()
  {
    return getValue();
  }

  public final BFacets getEnumFacets()
  {
    return BFacets.make(BFacets.RANGE, getEnum().getRange());
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////  
  
  /**
   * Set the value property using any enum.
   */
  public void setValue(BEnum x)
  {                                        
    setValue(BDynamicEnum.make(x));      
  }  

  /**
   * Get the value as a BValue.
   */
  public final BValue getValueValue()
  {
    return getValue();
  }

  /**
   * Get the "value" property.
   */
  public final Property getValueProperty()
  {
    return value;
  }

  /**
   * Format the value using <code>getValue().toString(context)</code>.
   */
  public String valueToString(Context context)
  {
    return getValue().toString(context);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("statusEnum.png");
      
}
